/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.bpmn2;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.compiler.compiler.BPMN2ProcessFactory;
import org.drools.compiler.compiler.BPMN2ProcessProvider;
import org.drools.compiler.compiler.PackageBuilder;
import org.drools.compiler.compiler.PackageBuilderConfiguration;
import org.drools.core.io.impl.ByteArrayResource;
import org.drools.core.xml.SemanticModule;
import org.jbpm.kie.services.api.bpmn2.BPMN2DataService;
import org.jbpm.kie.services.impl.bpmn2.BPMN2DataServiceSemanticModule;
import org.jbpm.kie.services.impl.bpmn2.ProcessDescRepoHelper;
import org.jbpm.kie.services.impl.bpmn2.ProcessDescriptionRepository;
import org.jbpm.kie.services.impl.model.ProcessDesc;
import org.jbpm.services.task.impl.model.TaskDefImpl;
import org.kie.api.definition.process.Process;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.definition.KnowledgePackage;

@ApplicationScoped
public class BPMN2DataServiceImpl
implements BPMN2DataService {
    @Inject
    private BPMN2DataServiceSemanticModule module;
    @Inject
    private ProcessDescriptionRepository repo;
    private BPMN2ProcessProvider provider;

    public void setSemanticModule(BPMN2DataServiceSemanticModule module) {
        this.module = module;
    }

    public void setRepository(ProcessDescriptionRepository repo) {
        this.repo = repo;
    }

    @PostConstruct
    public void init() {
        this.provider = new BPMN2ProcessProvider(){

            public void configurePackageBuilder(PackageBuilder packageBuilder) {
                PackageBuilderConfiguration conf = packageBuilder.getPackageBuilderConfiguration();
                if (conf.getSemanticModules().getSemanticModule("http://www.jboss.org/bpmn2-data-services") == null) {
                    conf.addSemanticModule((SemanticModule)BPMN2DataServiceImpl.this.module);
                }
            }
        };
    }

    @Override
    public Map<String, String> getTaskInputMappings(String processId, String taskName) {
        if (processId == null || "".equals(processId)) {
            throw new IllegalStateException("The Process id cannot be Empty!");
        }
        ProcessDescRepoHelper helper = this.repo.getProcessDesc(processId);
        if (helper == null) {
            throw new IllegalStateException("No process available with given id : " + processId);
        }
        return helper.getTaskInputMappings().get(taskName);
    }

    @Override
    public Map<String, String> getTaskOutputMappings(String processId, String taskName) {
        if (processId == null || "".equals(processId)) {
            throw new IllegalStateException("The Process id cannot be Empty!");
        }
        ProcessDescRepoHelper helper = this.repo.getProcessDesc(processId);
        if (helper == null) {
            throw new IllegalStateException("No process available with given id : " + processId);
        }
        return helper.getTaskOutputMappings().get(taskName);
    }

    @Override
    public Collection<TaskDefImpl> getAllTasksDef(String processId) {
        if (processId == null || "".equals(processId)) {
            throw new IllegalStateException("The Process id cannot be Empty!");
        }
        ProcessDescRepoHelper helper = this.repo.getProcessDesc(processId);
        if (helper == null) {
            throw new IllegalStateException("No process available with given id : " + processId);
        }
        return helper.getTasks().values();
    }

    @Override
    public Map<String, String> getAssociatedEntities(String processId) {
        if (processId == null || "".equals(processId)) {
            throw new IllegalStateException("The Process id cannot be Empty!");
        }
        ProcessDescRepoHelper helper = this.repo.getProcessDesc(processId);
        if (helper == null) {
            throw new IllegalStateException("No process available with given id : " + processId);
        }
        return helper.getTaskAssignments();
    }

    @Override
    public List<String> getAssociatedDomainObjects(String bpmn2Content) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Map<String, String> getProcessData(String processId) {
        if (processId == null || "".equals(processId)) {
            throw new IllegalStateException("The Process id cannot be Empty!");
        }
        ProcessDescRepoHelper helper = this.repo.getProcessDesc(processId);
        if (helper == null) {
            throw new IllegalStateException("No process available with given id : " + processId);
        }
        return helper.getInputs();
    }

    @Override
    public List<String> getAssociatedForms(String processId) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ProcessDesc getProcessDesc(String processId) {
        if (processId == null || "".equals(processId)) {
            throw new IllegalStateException("The Process id cannot be Empty!");
        }
        ProcessDescRepoHelper helper = this.repo.getProcessDesc(processId);
        if (helper == null) {
            throw new IllegalStateException("No process available with given id : " + processId);
        }
        return helper.getProcess();
    }

    @Override
    public Collection<String> getReusableSubProcesses(String processId) {
        if (processId == null || "".equals(processId)) {
            throw new IllegalStateException("The Process id cannot be Empty!");
        }
        ProcessDescRepoHelper helper = this.repo.getProcessDesc(processId);
        if (helper == null) {
            throw new IllegalStateException("No process available with given id : " + processId);
        }
        return helper.getReusableSubProcesses();
    }

    @Override
    public ProcessDesc findProcessId(String bpmn2Content) {
        if (bpmn2Content == null || "".equals(bpmn2Content)) {
            return null;
        }
        BPMN2ProcessProvider originalProvider = BPMN2ProcessFactory.getBPMN2ProcessProvider();
        if (originalProvider != this.provider) {
            BPMN2ProcessFactory.setBPMN2ProcessProvider((BPMN2ProcessProvider)this.provider);
        }
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add((Resource)new ByteArrayResource(bpmn2Content.getBytes()), ResourceType.BPMN2);
        if (kbuilder.hasErrors()) {
            for (KnowledgeBuilderError error : kbuilder.getErrors()) {
                System.out.println("Error: " + error.getMessage());
            }
            System.out.println(">> Process Cannot be Parsed! \n" + bpmn2Content);
            return null;
        }
        BPMN2ProcessFactory.setBPMN2ProcessProvider((BPMN2ProcessProvider)originalProvider);
        KnowledgePackage pckg = (KnowledgePackage)kbuilder.getKnowledgePackages().iterator().next();
        Process process = (Process)pckg.getProcesses().iterator().next();
        return new ProcessDesc(process.getId(), process.getName(), process.getVersion(), process.getPackageName(), process.getType(), process.getKnowledgeType().name(), process.getNamespace(), "");
    }
}

