/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.form;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jbpm.form.builder.services.model.InputData;
import org.jbpm.form.builder.services.model.OutputData;
import org.jbpm.kie.services.api.FormProviderService;
import org.jbpm.kie.services.api.RuntimeDataService;
import org.jbpm.kie.services.api.bpmn2.BPMN2DataService;
import org.jbpm.kie.services.impl.form.FormProvider;
import org.jbpm.kie.services.impl.model.ProcessDesc;
import org.jbpm.services.task.utils.ContentMarshallerHelper;
import org.kie.api.task.model.Content;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.TaskContentService;
import org.kie.internal.task.api.TaskInstanceService;
import org.kie.internal.task.api.TaskQueryService;

@ApplicationScoped
public class FormProviderServiceImpl
implements FormProviderService {
    @Inject
    private TaskQueryService queryService;
    @Inject
    private TaskContentService contentService;
    @Inject
    private TaskInstanceService instanceService;
    @Inject
    private BPMN2DataService bpmn2Service;
    @Inject
    private RuntimeDataService dataService;
    @Inject
    @Any
    private Instance<FormProvider> providersInjected;
    private Set<FormProvider> providers;

    @PostConstruct
    public void prepare() {
        this.providers = new TreeSet<FormProvider>(new Comparator<FormProvider>(){

            @Override
            public int compare(FormProvider o1, FormProvider o2) {
                return o1.getPriority() - o2.getPriority();
            }
        });
        for (FormProvider p : this.providersInjected) {
            this.providers.add(p);
        }
    }

    @Override
    public String getFormDisplayProcess(String processId) {
        FormProvider provider;
        ProcessDesc processDesc = this.dataService.getProcessById(processId);
        InputStream template = null;
        Iterator<FormProvider> i$ = this.providers.iterator();
        while (i$.hasNext() && (template = (provider = i$.next()).provideProcessForm(processDesc)) == null) {
        }
        Map<String, String> processData = this.bpmn2Service.getProcessData(processId);
        if (processData == null) {
            processData = new HashMap<String, String>();
        }
        HashMap<String, Object> renderContext = new HashMap<String, Object>();
        renderContext.put("process", processDesc);
        renderContext.put("outputs", processData);
        return this.render(processDesc.getName(), template, renderContext);
    }

    @Override
    public String getFormDisplayTask(long taskId) {
        FormProvider formProvider;
        Task task = this.queryService.getTaskInstanceById(taskId);
        String name = ((I18NText)task.getNames().get(0)).getText();
        ProcessDesc processDesc = this.dataService.getProcessById(task.getTaskData().getProcessId());
        HashMap<String, Object> renderContext = new HashMap<String, Object>();
        InputStream template = null;
        Object input = null;
        long inputContentId = task.getTaskData().getDocumentContentId();
        if (inputContentId != -1L) {
            Content content = this.contentService.getContentById(inputContentId);
            input = ContentMarshallerHelper.unmarshall((byte[])content.getContent(), null);
        }
        if (input == null) {
            input = new HashMap();
        }
        Object output = null;
        long outputContentId = task.getTaskData().getOutputContentId();
        if (outputContentId != -1L) {
            Content content = this.contentService.getContentById(outputContentId);
            output = ContentMarshallerHelper.unmarshall((byte[])content.getContent(), null);
        }
        if (output == null) {
            output = new HashMap();
        }
        String processId = task.getTaskData().getProcessId();
        Map<Object, Object> taskOutputMappings = null;
        if (processId != null && !processId.equals("")) {
            taskOutputMappings = this.bpmn2Service.getTaskOutputMappings(processId, ((I18NText)task.getNames().iterator().next()).getText());
        }
        if (taskOutputMappings == null) {
            taskOutputMappings = new HashMap();
        }
        HashMap<String, String> finalOutput = new HashMap<String, String>();
        for (String string : taskOutputMappings.values()) {
            String value = (String)((Map)output).get(string);
            if (value == null) {
                value = "";
            }
            finalOutput.put(string, value);
        }
        renderContext.put("task", task);
        renderContext.put("outputs", finalOutput);
        if (input instanceof Map) {
            renderContext.put("inputs", input);
            for (Map.Entry entry : ((Map)input).entrySet()) {
                renderContext.put((String)entry.getKey(), entry.getValue());
            }
        } else {
            renderContext.put("input", input);
        }
        Iterator<Object> i$ = this.providers.iterator();
        while (i$.hasNext() && (template = (formProvider = (FormProvider)i$.next()).provideTaskForm(task, processDesc)) == null) {
        }
        return this.render(name, template, renderContext);
    }

    public String render(String name, InputStream src, Map<String, Object> renderContext) {
        String str = null;
        try {
            Configuration cfg = new Configuration();
            cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
            cfg.setTemplateUpdateDelay(0);
            Template temp = new Template(name, (Reader)new InputStreamReader(src), cfg);
            StringWriter out = new StringWriter();
            temp.process(renderContext, (Writer)out);
            out.flush();
            str = out.getBuffer().toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to process form template", e);
        }
        return str;
    }

    protected Map<String, InputData> toInputDataMap(Map<String, String> inputs) {
        HashMap<String, InputData> retval = new HashMap<String, InputData>();
        if (inputs != null) {
            for (String key : inputs.keySet()) {
                InputData in = new InputData();
                in.setName(key);
                retval.put(key, in);
            }
        }
        return retval;
    }

    protected Map<String, OutputData> toOutputDataMap(Map<String, String> outputs) {
        HashMap<String, OutputData> retval = new HashMap<String, OutputData>();
        if (outputs != null) {
            for (String key : outputs.keySet()) {
                OutputData out = new OutputData();
                out.setName(key);
                retval.put(key, out);
            }
        }
        return retval;
    }
}

