/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.form;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.drools.core.util.StringUtils;
import org.jbpm.kie.services.api.FormProviderService;
import org.jbpm.kie.services.api.RuntimeDataService;
import org.jbpm.kie.services.api.bpmn2.BPMN2DataService;
import org.jbpm.kie.services.impl.form.FormProvider;
import org.jbpm.kie.services.impl.model.ProcessAssetDesc;
import org.jbpm.services.task.impl.TaskContentRegistry;
import org.jbpm.services.task.utils.ContentMarshallerHelper;
import org.kie.api.runtime.Environment;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Content;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.Task;
import org.kie.internal.deployment.DeployedUnit;
import org.kie.internal.deployment.DeploymentService;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.kie.internal.task.api.ContentMarshallerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class FormProviderServiceImpl
implements FormProviderService {
    private static Logger logger = LoggerFactory.getLogger(FormProviderServiceImpl.class);
    @Inject
    private TaskService taskService;
    @Inject
    private BPMN2DataService bpmn2Service;
    @Inject
    private RuntimeDataService dataService;
    @Inject
    private DeploymentService deploymentService;
    @Inject
    @Any
    private Instance<FormProvider> providersInjected;
    private Set<FormProvider> providers;

    @PostConstruct
    public void prepare() {
        this.providers = new TreeSet<FormProvider>(new Comparator<FormProvider>(){

            @Override
            public int compare(FormProvider o1, FormProvider o2) {
                return o1.getPriority() - o2.getPriority();
            }
        });
        for (FormProvider p : this.providersInjected) {
            this.providers.add(p);
        }
    }

    @Override
    public String getFormDisplayProcess(String deploymentId, String processId) {
        ProcessAssetDesc processDesc = this.dataService.getProcessesByDeploymentIdProcessId(deploymentId, processId);
        Map<String, String> processData = this.bpmn2Service.getProcessData(processId);
        if (processData == null) {
            processData = new HashMap<String, String>();
        }
        HashMap<String, Object> renderContext = new HashMap<String, Object>();
        renderContext.put("process", processDesc);
        renderContext.put("outputs", processData);
        renderContext.put("marshallerContext", this.getMarshallerContext(deploymentId, processId));
        for (FormProvider provider : this.providers) {
            String template = provider.render(processDesc.getName(), processDesc, renderContext);
            if (StringUtils.isEmpty((CharSequence)template)) continue;
            return template;
        }
        logger.warn("Unable to find form to render for process '{}'", (Object)processDesc.getName());
        return "";
    }

    @Override
    public String getFormDisplayTask(long taskId) {
        Task task = this.taskService.getTaskById(taskId);
        if (task == null) {
            return "";
        }
        String name = ((I18NText)task.getNames().get(0)).getText();
        ProcessAssetDesc processDesc = this.dataService.getProcessesByDeploymentIdProcessId(task.getTaskData().getDeploymentId(), task.getTaskData().getProcessId());
        HashMap<String, Object> renderContext = new HashMap<String, Object>();
        ContentMarshallerContext marshallerContext = this.getMarshallerContext(task);
        Object input = null;
        long inputContentId = task.getTaskData().getDocumentContentId();
        if (inputContentId != -1L) {
            Content content = this.taskService.getContentById(inputContentId);
            input = ContentMarshallerHelper.unmarshall((byte[])content.getContent(), (Environment)marshallerContext.getEnvironment(), (ClassLoader)marshallerContext.getClassloader());
        }
        if (input == null) {
            input = new HashMap();
        }
        Object output = null;
        long outputContentId = task.getTaskData().getOutputContentId();
        if (outputContentId != -1L) {
            Content content = this.taskService.getContentById(outputContentId);
            output = ContentMarshallerHelper.unmarshall((byte[])content.getContent(), (Environment)marshallerContext.getEnvironment(), (ClassLoader)marshallerContext.getClassloader());
        }
        if (output == null) {
            output = new HashMap();
        }
        String processId = task.getTaskData().getProcessId();
        Map<Object, Object> taskOutputMappings = null;
        if (processId != null && !processId.equals("")) {
            taskOutputMappings = this.bpmn2Service.getTaskOutputMappings(processId, ((I18NText)task.getNames().iterator().next()).getText());
        }
        if (taskOutputMappings == null) {
            taskOutputMappings = new HashMap();
        }
        HashMap finalOutput = new HashMap();
        for (String string : taskOutputMappings.values()) {
            Object value = ((Map)output).get(string);
            if (value == null) {
                value = "";
            }
            finalOutput.put(string, value);
        }
        renderContext.put("task", task);
        renderContext.put("marshallerContext", marshallerContext);
        if (input instanceof Map) {
            renderContext.put("inputs", input);
            for (Map.Entry entry : ((Map)input).entrySet()) {
                renderContext.put((String)entry.getKey(), entry.getValue());
            }
        } else {
            renderContext.put("input", input);
        }
        renderContext.put("outputs", finalOutput);
        for (Map.Entry entry : finalOutput.entrySet()) {
            renderContext.put((String)entry.getKey(), entry.getValue());
        }
        for (FormProvider formProvider : this.providers) {
            String template = formProvider.render(name, task, processDesc, renderContext);
            if (StringUtils.isEmpty((CharSequence)template)) continue;
            return template;
        }
        logger.warn("Unable to find form to render for task '{}' on process '{}'", (Object)name, (Object)processDesc.getName());
        return "";
    }

    protected ContentMarshallerContext getMarshallerContext(String deploymentId, String processId) {
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(deploymentId);
        if (deployedUnit == null) {
            return new ContentMarshallerContext();
        }
        InternalRuntimeManager manager = (InternalRuntimeManager)deployedUnit.getRuntimeManager();
        return new ContentMarshallerContext(manager.getEnvironment().getEnvironment(), manager.getEnvironment().getClassLoader());
    }

    protected ContentMarshallerContext getMarshallerContext(Task task) {
        if (task == null) {
            return new ContentMarshallerContext();
        }
        return TaskContentRegistry.get().getMarshallerContext(task);
    }
}

