/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.bpmn2;

import org.drools.core.xml.ExtensibleXmlParser;
import org.jbpm.bpmn2.xml.ProcessHandler;
import org.jbpm.kie.services.impl.bpmn2.ProcessDescRepoHelper;
import org.jbpm.kie.services.impl.bpmn2.ProcessDescriptionRepository;
import org.jbpm.kie.services.impl.model.ProcessAssetDesc;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ProcessGetInformationHandler
extends ProcessHandler {
    private ProcessDescriptionRepository repository;
    private ProcessDescRepoHelper repositoryHelper;

    public ProcessGetInformationHandler() {
    }

    public ProcessGetInformationHandler(ProcessDescRepoHelper repoHelper, ProcessDescriptionRepository repo) {
        this.repository = repo;
        this.repositoryHelper = repoHelper;
    }

    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        String processId = attrs.getValue("id");
        String processName = attrs.getValue("name");
        String packageName = attrs.getValue("http://www.jboss.org/drools", "package");
        String processType = attrs.getValue("type");
        String namespace = attrs.getValue("namespace");
        String version = attrs.getValue("http://www.jboss.org/drools", "version");
        ProcessDescRepoHelper value = new ProcessDescRepoHelper();
        value.setProcess(new ProcessAssetDesc(processId, processName, version, packageName, processType, "", namespace, ""));
        this.repository.addProcessDescription(processId, value);
        this.repositoryHelper.setProcess(value.getProcess());
        return super.start(uri, localName, attrs, parser);
    }

    public void setRepositoryHelper(ProcessDescRepoHelper repositoryHelper) {
        this.repositoryHelper = repositoryHelper;
    }

    public void setRepository(ProcessDescriptionRepository repository) {
        this.repository = repository;
    }

    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        this.repositoryHelper.clear();
        return super.end(uri, localName, parser);
    }
}

