/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.bpmn2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.drools.core.xml.ExtensibleXmlParser;
import org.jbpm.bpmn2.core.ItemDefinition;
import org.jbpm.bpmn2.xml.UserTaskHandler;
import org.jbpm.compiler.xml.ProcessBuildData;
import org.jbpm.kie.services.impl.bpmn2.BPMN2DataServiceSemanticModule;
import org.jbpm.kie.services.impl.bpmn2.ProcessDescriptionRepository;
import org.jbpm.kie.services.impl.bpmn2.UserTaskDefinitionImpl;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.node.HumanTaskNode;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.xml.sax.SAXException;

public class HumanTaskGetInformationHandler
extends UserTaskHandler {
    private ProcessDescriptionRepository repository;
    private BPMN2DataServiceSemanticModule module;
    private Map<String, ItemDefinition> itemDefinitions;

    public HumanTaskGetInformationHandler() {
    }

    public HumanTaskGetInformationHandler(BPMN2DataServiceSemanticModule module) {
        this.module = module;
        this.repository = module.getRepo();
    }

    protected void readIoSpecification(org.w3c.dom.Node xmlNode, Map<String, String> dataInputs, Map<String, String> dataOutputs) {
        dataInputs.clear();
        dataOutputs.clear();
        HashMap<String, String> dataTypeInputs = new HashMap<String, String>();
        HashMap<String, String> dataTypeOutputs = new HashMap<String, String>();
        org.w3c.dom.Node subNode = xmlNode.getFirstChild();
        while (subNode instanceof Element) {
            String dataType;
            String itemSubjectRef;
            String id;
            String subNodeName = subNode.getNodeName();
            if ("dataInput".equals(subNodeName)) {
                id = ((Element)subNode).getAttribute("id");
                String inputName = ((Element)subNode).getAttribute("name");
                itemSubjectRef = ((Element)subNode).getAttribute("itemSubjectRef");
                dataInputs.put(id, inputName);
                if (itemSubjectRef == null || itemSubjectRef.isEmpty()) {
                    dataType = ((Element)subNode).getAttribute("dtype");
                    if (dataType == null || dataType.isEmpty()) {
                        dataType = "java.lang.String";
                    }
                    dataTypeInputs.put(inputName, dataType);
                } else {
                    dataTypeInputs.put(inputName, this.itemDefinitions.get(itemSubjectRef).getStructureRef());
                }
            }
            if ("dataOutput".equals(subNodeName)) {
                id = ((Element)subNode).getAttribute("id");
                String outputName = ((Element)subNode).getAttribute("name");
                itemSubjectRef = ((Element)subNode).getAttribute("itemSubjectRef");
                dataOutputs.put(id, outputName);
                if (itemSubjectRef == null || itemSubjectRef.isEmpty()) {
                    dataType = ((Element)subNode).getAttribute("dtype");
                    if (dataType == null || dataType.isEmpty()) {
                        dataType = "java.lang.String";
                    }
                    dataTypeOutputs.put(outputName, dataType);
                } else {
                    dataTypeOutputs.put(outputName, this.itemDefinitions.get(itemSubjectRef).getStructureRef());
                }
            }
            subNode = subNode.getNextSibling();
        }
        NamedNodeMap map = xmlNode.getParentNode().getAttributes();
        org.w3c.dom.Node nodeName = map.getNamedItem("name");
        String name = nodeName.getNodeValue();
        HumanTaskGetInformationHandler humanTaskGetInformationHandler = this;
        String mainProcessId = humanTaskGetInformationHandler.module.getRepoHelper().getProcess().getId();
        UserTaskDefinitionImpl task = (UserTaskDefinitionImpl)this.repository.getProcessDesc(mainProcessId).getTasks().get(name);
        if (task == null) {
            task = new UserTaskDefinitionImpl();
            task.setName(name);
            this.repository.getProcessDesc(mainProcessId).getTasks().put(task.getName(), task);
        }
        HashMap<String, String> inputParams = new HashMap<String, String>();
        for (Map.Entry in : dataTypeInputs.entrySet()) {
            inputParams.put((String)in.getKey(), (String)in.getValue());
        }
        HashMap<String, String> outputParams = new HashMap<String, String>();
        for (Map.Entry out : dataTypeOutputs.entrySet()) {
            outputParams.put((String)out.getKey(), (String)out.getValue());
        }
        task.setTaskInputMappings(inputParams);
        task.setTaskOutputMappings(outputParams);
        task.setComment((String)inputParams.get("Comment"));
        task.setCreatedBy((String)inputParams.get("CreatedBy"));
        task.setPriority(this.getInteger((String)inputParams.get("Priority")));
        task.setSkippable("true".equalsIgnoreCase((String)inputParams.get("Skippable")));
        this.repository.getProcessDesc(mainProcessId).getTaskInputMappings().put(task.getName(), inputParams);
        this.repository.getProcessDesc(mainProcessId).getTaskOutputMappings().put(task.getName(), outputParams);
    }

    protected void handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        this.itemDefinitions = (Map)((ProcessBuildData)parser.getData()).getMetaData("ItemDefinitions");
        super.handleNode(node, element, uri, localName, parser);
        WorkItemNode humanTaskNode = (WorkItemNode)node;
        Map parameters = humanTaskNode.getWork().getParameters();
        HumanTaskGetInformationHandler humanTaskGetInformationHandler = this;
        String mainProcessId = humanTaskGetInformationHandler.module.getRepoHelper().getProcess().getId();
        String name = humanTaskNode.getName();
        UserTaskDefinitionImpl task = (UserTaskDefinitionImpl)this.repository.getProcessDesc(mainProcessId).getTasks().get(name);
        if (task == null) {
            task = new UserTaskDefinitionImpl();
            task.setName(name);
            this.repository.getProcessDesc(mainProcessId).getTasks().put(task.getName(), task);
        }
        Collection<String> currentAssignment = this.repository.getProcessDesc(mainProcessId).getTaskAssignments().get(humanTaskNode.getName());
        for (String parameter : parameters.keySet()) {
            if (!parameter.equals("GroupId")) continue;
            if (currentAssignment == null) {
                currentAssignment = new ArrayList<String>();
                this.repository.getProcessDesc(mainProcessId).getTaskAssignments().put(humanTaskNode.getName(), currentAssignment);
            }
            currentAssignment.add(humanTaskNode.getWork().getParameter(parameter).toString());
        }
        ((UserTaskDefinitionImpl)this.repository.getProcessDesc(mainProcessId).getTasks().get(humanTaskNode.getName())).setAssociatedEntities(currentAssignment);
        this.itemDefinitions = null;
    }

    protected String readPotentialOwner(org.w3c.dom.Node xmlNode, HumanTaskNode humanTaskNode) {
        Collection<String> currentAssignment;
        String user = xmlNode.getFirstChild().getFirstChild().getFirstChild().getTextContent();
        HumanTaskGetInformationHandler humanTaskGetInformationHandler = this;
        String mainProcessId = humanTaskGetInformationHandler.module.getRepoHelper().getProcess().getId();
        String name = humanTaskNode.getName();
        UserTaskDefinitionImpl task = (UserTaskDefinitionImpl)this.repository.getProcessDesc(mainProcessId).getTasks().get(name);
        if (task == null) {
            task = new UserTaskDefinitionImpl();
            task.setName(name);
            this.repository.getProcessDesc(mainProcessId).getTasks().put(task.getName(), task);
        }
        if ((currentAssignment = this.repository.getProcessDesc(mainProcessId).getTaskAssignments().get(humanTaskNode.getName())) == null) {
            currentAssignment = new ArrayList<String>();
            this.repository.getProcessDesc(mainProcessId).getTaskAssignments().put(humanTaskNode.getName(), currentAssignment);
        }
        currentAssignment.add(user);
        task.setAssociatedEntities(currentAssignment);
        return user;
    }

    public void setRepository(ProcessDescriptionRepository repository) {
        this.repository = repository;
    }

    private Integer getInteger(String value) {
        int priority = 0;
        if (value != null) {
            try {
                priority = new Integer(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return priority;
    }
}

