/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.admin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.kie.services.impl.admin.MigrationEntryImpl;
import org.jbpm.kie.services.impl.admin.MigrationReportImpl;
import org.jbpm.runtime.manager.impl.migration.MigrationEntry;
import org.jbpm.runtime.manager.impl.migration.MigrationException;
import org.jbpm.runtime.manager.impl.migration.MigrationManager;
import org.jbpm.runtime.manager.impl.migration.MigrationSpec;
import org.jbpm.services.api.admin.MigrationReport;
import org.jbpm.services.api.admin.ProcessInstanceMigrationService;

public class ProcessInstanceMigrationServiceImpl
implements ProcessInstanceMigrationService {
    public MigrationReport migrate(String sourceDeploymentId, Long processInstanceId, String targetDeploymentId, String targetProcessId) {
        MigrationSpec migrationSpec = new MigrationSpec(sourceDeploymentId, processInstanceId, targetDeploymentId, targetProcessId);
        MigrationManager migrationManager = new MigrationManager(migrationSpec);
        org.jbpm.runtime.manager.impl.migration.MigrationReport report = null;
        try {
            report = migrationManager.migrate();
        }
        catch (MigrationException e) {
            report = e.getReport();
        }
        return this.convert(report);
    }

    public MigrationReport migrate(String sourceDeploymentId, Long processInstanceId, String targetDeploymentId, String targetProcessId, Map<String, String> nodeMapping) {
        MigrationSpec migrationSpec = new MigrationSpec(sourceDeploymentId, processInstanceId, targetDeploymentId, targetProcessId);
        MigrationManager migrationManager = new MigrationManager(migrationSpec);
        org.jbpm.runtime.manager.impl.migration.MigrationReport report = null;
        try {
            report = migrationManager.migrate(nodeMapping);
        }
        catch (MigrationException e) {
            report = e.getReport();
        }
        return this.convert(report);
    }

    public List<MigrationReport> migrate(String sourceDeploymentId, List<Long> processInstanceIds, String targetDeploymentId, String targetProcessId) {
        return this.migrate(sourceDeploymentId, processInstanceIds, targetDeploymentId, targetProcessId, new HashMap<String, String>());
    }

    public List<MigrationReport> migrate(String sourceDeploymentId, List<Long> processInstanceIds, String targetDeploymentId, String targetProcessId, Map<String, String> nodeMapping) {
        ArrayList<MigrationReport> reports = new ArrayList<MigrationReport>();
        for (Long pId : processInstanceIds) {
            MigrationReport report = this.migrate(sourceDeploymentId, pId, targetDeploymentId, targetProcessId, nodeMapping);
            reports.add(report);
        }
        return reports;
    }

    protected MigrationReport convert(org.jbpm.runtime.manager.impl.migration.MigrationReport report) {
        ArrayList<org.jbpm.services.api.admin.MigrationEntry> logs = new ArrayList<org.jbpm.services.api.admin.MigrationEntry>();
        for (MigrationEntry orig : report.getEntries()) {
            logs.add(new MigrationEntryImpl(orig.getTimestamp(), orig.getMessage(), orig.getType().toString()));
        }
        return new MigrationReportImpl(report.isSuccessful(), report.getStartDate(), report.getEndDate(), logs);
    }
}

