/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.form.provider;

import java.io.ByteArrayInputStream;
import java.util.Map;
import org.jbpm.kie.services.impl.form.provider.FreemakerFormProvider;
import org.jbpm.kie.services.impl.model.ProcessAssetDesc;
import org.jbpm.services.api.model.ProcessDefinition;
import org.kie.api.task.model.Task;

public class InMemoryFormProvider
extends FreemakerFormProvider {
    private static final String DEFAULT_PROCESS = "DefaultProcess";
    private static final String DEFAULT_TASK = "DefaultTask";

    @Override
    public String render(String name, ProcessDefinition process, Map<String, Object> renderContext) {
        Object asset = null;
        if (!(process instanceof ProcessAssetDesc)) {
            return null;
        }
        String templateString = this.formManagerService.getFormByKey(process.getDeploymentId(), process.getId());
        if (templateString == null) {
            templateString = this.formManagerService.getFormByKey(process.getDeploymentId(), process.getId() + this.getFormSuffix());
        }
        if (templateString == null || templateString.isEmpty()) {
            return null;
        }
        return this.render(name, new ByteArrayInputStream(templateString.getBytes()), renderContext);
    }

    @Override
    public String render(String name, Task task, ProcessDefinition process, Map<String, Object> renderContext) {
        if (task == null) {
            return null;
        }
        String lookupName = this.getTaskFormName(task);
        if (lookupName == null || lookupName.isEmpty()) {
            return null;
        }
        String templateString = this.formManagerService.getFormByKey(task.getTaskData().getDeploymentId(), lookupName);
        if (templateString == null || templateString.isEmpty()) {
            return null;
        }
        return this.render(name, new ByteArrayInputStream(templateString.getBytes()), renderContext);
    }

    @Override
    public int getPriority() {
        return 3;
    }

    @Override
    protected String getFormExtension() {
        return ".ftl";
    }
}

