/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import org.dashbuilder.dataset.filter.CoreFunctionType;
import org.jbpm.kie.services.impl.model.ProcessInstanceWithVarsDesc;
import org.jbpm.kie.services.impl.model.UserTaskInstanceWithPotOwnerDesc;
import org.jbpm.services.api.query.model.QueryParam;
import org.jbpm.shared.services.impl.QueryManager;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.jbpm.shared.services.impl.commands.QueryNameCommand;
import org.kie.api.command.Command;
import org.kie.api.runtime.query.QueryContext;

public abstract class AbstractAdvanceRuntimeDataServiceImpl {
    private static final String ID_LIST = "idList";
    private EntityManagerFactory emf;
    private TransactionalCommandService commandService;

    public AbstractAdvanceRuntimeDataServiceImpl() {
        QueryManager.get().addNamedQueries("META-INF/Servicesorm.xml");
    }

    public void setCommandService(TransactionalCommandService commandService) {
        this.commandService = commandService;
    }

    public void setEmf(EntityManagerFactory emf) {
        this.emf = emf;
    }

    public List<org.jbpm.services.api.model.ProcessInstanceWithVarsDesc> queryProcessByVariables(List<QueryParam> attributes, List<QueryParam> variables, int processType, String varPrefix, QueryContext queryContext) {
        EntityManager entityManager = this.emf.createEntityManager();
        StringBuilder derivedTables = new StringBuilder();
        if (!variables.isEmpty()) {
            ArrayList conditions = new ArrayList();
            variables.stream().forEach(expr -> conditions.add("(A1.variableId = :NAME_" + expr.getColumn() + " AND " + this.computeExpression((QueryParam)expr, "A1.value", ":VALUE_" + expr.getColumn()) + ")\n"));
            String where = String.join((CharSequence)" OR ", conditions);
            derivedTables.append("INNER JOIN (SELECT A1.processInstanceId \nFROM VariableInstanceLog A1 \nLEFT JOIN VariableInstanceLog A2 ON A1.processId = A2.processId AND A1.processInstanceId = A2.processInstanceId AND A1.variableInstanceId = A2.variableInstanceId AND A2.id > A1.id  \nWHERE A2.id IS NULL AND (" + where + ") GROUP BY A1.processInstanceId HAVING COUNT(*) = :NUMBER_OF_VARS ) TABLE_VAR ON TABLE_VAR.processInstanceId = pil.processInstanceId \n");
        }
        StringBuilder globalWhere = new StringBuilder();
        attributes.stream().forEach(expr -> globalWhere.append(" AND " + this.computeExpression((QueryParam)expr, expr.getColumn(), ":ATTR_" + expr.getColumn())));
        String procSQLString = " SELECT DISTINCT pil.processInstanceId  FROM ProcessInstanceLog pil \n " + derivedTables + " WHERE pil.processType = :processType " + globalWhere + " ORDER BY pil.processInstanceId ASC ";
        Query query = entityManager.createNativeQuery(procSQLString);
        variables.stream().forEach(var -> query.setParameter("NAME_" + var.getColumn(), (Object)(varPrefix + var.getColumn())));
        variables.stream().filter(e -> e.getObjectValue() != null).forEach(var -> query.setParameter("VALUE_" + var.getColumn(), var.getObjectValue()));
        attributes.stream().filter(e -> e.getObjectValue() != null).forEach(entry -> query.setParameter("ATTR_" + entry.getColumn(), entry.getObjectValue()));
        if (!variables.isEmpty()) {
            query.setParameter("NUMBER_OF_VARS", (Object)variables.size());
        }
        query.setParameter("processType", (Object)processType);
        this.addPagination(query, queryContext);
        List ids = query.getResultList();
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        List procRows = (List)this.commandService.execute((Command)new QueryNameCommand("GetProcessInstanceByIdList", Collections.singletonMap(ID_LIST, ids)));
        List varRows = (List)this.commandService.execute((Command)new QueryNameCommand("GetVariablesByProcessInstanceIdList", Collections.singletonMap(ID_LIST, ids)));
        int currentVarIdx = 0;
        ArrayList<org.jbpm.services.api.model.ProcessInstanceWithVarsDesc> data = new ArrayList<org.jbpm.services.api.model.ProcessInstanceWithVarsDesc>();
        for (Object[] row : procRows) {
            ProcessInstanceWithVarsDesc pwv = this.toProcessInstanceWithVarsDesc(row);
            HashMap<String, Object> vars = new HashMap<String, Object>();
            pwv.setVariables(vars);
            HashMap<String, Object> extra = new HashMap<String, Object>();
            pwv.setExtraData(extra);
            while (currentVarIdx < varRows.size() && row[0].equals(((Object[])varRows.get(currentVarIdx))[0])) {
                String name = (String)((Object[])varRows.get(currentVarIdx))[1];
                if (!varPrefix.isEmpty() && name.startsWith(varPrefix)) {
                    extra.put(name.substring(varPrefix.length()), ((Object[])varRows.get(currentVarIdx))[2]);
                } else {
                    vars.put(name, ((Object[])varRows.get(currentVarIdx))[2]);
                }
                ++currentVarIdx;
            }
            data.add(pwv);
        }
        entityManager.close();
        return data;
    }

    private String computeExpression(QueryParam expr, String leftOperand, String rightOperand) {
        CoreFunctionType type = CoreFunctionType.getByName((String)expr.getOperator());
        switch (type) {
            case IS_NULL: {
                return leftOperand + " IS NULL ";
            }
            case NOT_NULL: {
                return leftOperand + " IS NOT NULL ";
            }
            case IN: {
                return leftOperand + " IN (" + rightOperand + ") ";
            }
            case NOT_IN: {
                return leftOperand + " NOT IN (" + rightOperand + ") ";
            }
            case EQUALS_TO: {
                return leftOperand + " = " + rightOperand + " ";
            }
            case NOT_EQUALS_TO: {
                return leftOperand + " <> " + rightOperand + " ";
            }
            case LIKE_TO: {
                return leftOperand + " LIKE " + rightOperand + " ";
            }
        }
        throw new UnsupportedOperationException("Queryparam: " + expr + " not supported");
    }

    private ProcessInstanceWithVarsDesc toProcessInstanceWithVarsDesc(Object[] row) {
        return new ProcessInstanceWithVarsDesc(((Number)row[0]).longValue(), (String)row[1], (String)row[2], (String)row[3], ((Number)row[4]).intValue(), (String)row[5], (Date)row[6], (String)row[7], (String)row[8]);
    }

    private void addPagination(Query query, QueryContext context) {
        if (context.getCount() > 0) {
            query.setFirstResult(context.getOffset().intValue());
            query.setMaxResults(context.getCount().intValue());
        }
    }

    public List<org.jbpm.services.api.model.UserTaskInstanceWithPotOwnerDesc> queryUserTasksByVariables(List<QueryParam> attributes, List<QueryParam> variables, List<QueryParam> processVariables, List<String> owners, int processType, String varPrefix, QueryContext queryContext) {
        String where;
        ArrayList conditions;
        EntityManager entityManager = this.emf.createEntityManager();
        StringBuilder globalWhere = new StringBuilder();
        StringBuilder derivedTables = new StringBuilder();
        if (!variables.isEmpty()) {
            conditions = new ArrayList();
            variables.stream().forEach(expr -> conditions.add("(name = :V_NAME_" + expr.getColumn() + " AND " + this.computeExpression((QueryParam)expr, "value", ":V_VALUE_" + expr.getColumn()) + ")\n"));
            where = String.join((CharSequence)" OR ", conditions);
            derivedTables.append("INNER JOIN (\nSELECT taskId \nFROM TaskVariableImpl \nWHERE type = 0 AND (" + where + ")\nGROUP BY taskId \nHAVING COUNT(*) = :NUMBER_OF_TASKVARS \n) TABLE_TASK_VAR ON TABLE_TASK_VAR.taskId = task.id  \n");
        }
        if (!processVariables.isEmpty()) {
            conditions = new ArrayList();
            processVariables.stream().forEach(expr -> conditions.add("(A1.variableId = :P_NAME_" + expr.getColumn() + " AND " + this.computeExpression((QueryParam)expr, "A1.value", ":P_VALUE_" + expr.getColumn()) + ")\n"));
            where = String.join((CharSequence)" OR ", conditions);
            derivedTables.append("INNER JOIN (SELECT A1.processInstanceId \nFROM VariableInstanceLog A1 \nLEFT JOIN VariableInstanceLog A2 ON A1.processId = A2.processId AND A1.processInstanceId = A2.processInstanceId AND A1.variableInstanceId = A2.variableInstanceId AND A2.id > A1.id  \nWHERE A2.id IS NULL AND (" + where + ") GROUP BY A1.processInstanceId HAVING COUNT(*) = :NUMBER_OF_PROCVARS ) TABLE_PROC_VAR ON TABLE_PROC_VAR.processInstanceId = pil.processInstanceId \n");
        }
        if (!owners.isEmpty()) {
            derivedTables.append("INNER JOIN ( \n           SELECT DISTINCT po.task_id \n           FROM PeopleAssignments_PotOwners po \n           WHERE po.entity_id IN (:owners) \n           GROUP BY po.task_id \n           HAVING COUNT(po.entity_id) = :num_owners \n) pot ON pot.task_id = task.id ");
        }
        attributes.stream().forEach(expr -> globalWhere.append(" AND " + this.computeExpression((QueryParam)expr, expr.getColumn(), ":ATTR_" + expr.getColumn())));
        String procSQLString = "SELECT DISTINCT task.id  FROM Task task  INNER JOIN ProcessInstanceLog pil ON pil.processInstanceId = task.processInstanceId \n " + derivedTables + " WHERE  pil.processType = :processType " + globalWhere + " ORDER BY task.id ASC ";
        Query query = entityManager.createNativeQuery(procSQLString);
        variables.stream().forEach(var -> query.setParameter("V_NAME_" + var.getColumn(), (Object)var.getColumn()));
        variables.stream().filter(e -> e.getObjectValue() != null).forEach(var -> query.setParameter("V_VALUE_" + var.getColumn(), var.getObjectValue()));
        if (!variables.isEmpty()) {
            query.setParameter("NUMBER_OF_TASKVARS", (Object)variables.size());
        }
        processVariables.stream().forEach(var -> query.setParameter("P_NAME_" + var.getColumn(), (Object)(varPrefix + var.getColumn())));
        processVariables.stream().filter(e -> e.getObjectValue() != null).forEach(var -> query.setParameter("P_VALUE_" + var.getColumn(), var.getObjectValue()));
        if (!processVariables.isEmpty()) {
            query.setParameter("NUMBER_OF_PROCVARS", (Object)processVariables.size());
        }
        if (!owners.isEmpty()) {
            query.setParameter("num_owners", (Object)owners.size());
            query.setParameter("owners", owners);
        }
        attributes.stream().filter(e -> e.getObjectValue() != null).forEach(entry -> query.setParameter("ATTR_" + entry.getColumn(), entry.getObjectValue()));
        query.setParameter("processType", (Object)processType);
        this.addPagination(query, queryContext);
        List ids = query.getResultList();
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        entityManager.close();
        return this.collectData(ids, varPrefix);
    }

    private List<org.jbpm.services.api.model.UserTaskInstanceWithPotOwnerDesc> collectData(List<Number> ids, String varPrefix) {
        List taskRows = (List)this.commandService.execute((Command)new QueryNameCommand("GetTasksByIdList", Collections.singletonMap(ID_LIST, ids)));
        List varRows = (List)this.commandService.execute((Command)new QueryNameCommand("GetTaskVariablesByTaskIdList", Collections.singletonMap(ID_LIST, ids)));
        List potRows = (List)this.commandService.execute((Command)new QueryNameCommand("GetPotentialOwnersByTaskIdList", Collections.singletonMap(ID_LIST, ids)));
        List varProcSQLRows = (List)this.commandService.execute((Command)new QueryNameCommand("GetProcessVariablesByTaskIdList", Collections.singletonMap(ID_LIST, ids)));
        int currentVarIdx = 0;
        int currentPotIdx = 0;
        int currentVarProcIdx = 0;
        ArrayList<org.jbpm.services.api.model.UserTaskInstanceWithPotOwnerDesc> data = new ArrayList<org.jbpm.services.api.model.UserTaskInstanceWithPotOwnerDesc>();
        for (Object[] row : taskRows) {
            UserTaskInstanceWithPotOwnerDesc pwv = this.toUserTaskInstanceWithPotOwnerDesc(row);
            while (currentVarIdx < varRows.size() && row[0].equals(((Object[])varRows.get(currentVarIdx))[0])) {
                if (((Number)((Object[])varRows.get(currentVarIdx))[1]).intValue() == 0) {
                    pwv.addInputdata((String)((Object[])varRows.get(currentVarIdx))[2], ((Object[])varRows.get(currentVarIdx))[3]);
                } else {
                    pwv.addOutputdata((String)((Object[])varRows.get(currentVarIdx))[2], ((Object[])varRows.get(currentVarIdx))[3]);
                }
                ++currentVarIdx;
            }
            pwv.getPotentialOwners().clear();
            while (currentPotIdx < potRows.size() && row[0].equals(((Object[])potRows.get(currentPotIdx))[0])) {
                pwv.addPotOwner((String)((Object[])potRows.get(currentPotIdx))[1]);
                ++currentPotIdx;
            }
            while (currentVarProcIdx < varProcSQLRows.size() && row[0].equals(((Object[])varProcSQLRows.get(currentVarProcIdx))[0])) {
                String name = (String)((Object[])varProcSQLRows.get(currentVarProcIdx))[1];
                Object value = ((Object[])varProcSQLRows.get(currentVarProcIdx))[2];
                if (!varPrefix.isEmpty() && name.startsWith(varPrefix)) {
                    pwv.addExtraData(name.substring(varPrefix.length()), value);
                } else {
                    pwv.addProcessVariable(name, value);
                }
                ++currentVarProcIdx;
            }
            data.add(pwv);
        }
        return data;
    }

    private UserTaskInstanceWithPotOwnerDesc toUserTaskInstanceWithPotOwnerDesc(Object[] row) {
        return new UserTaskInstanceWithPotOwnerDesc(((Number)row[0]).longValue(), (String)row[1], (String)row[2], (String)row[3], (String)row[4], null, (String)row[5], (Date)row[6], (String)row[7], (Date)row[8], null, null, ((Number)row[9]).intValue(), (String)row[10], ((Number)row[11]).longValue(), (String)row[12], (String)row[13], (String)row[14]);
    }

    protected List<QueryParam> translate(Map<String, String> translationTable, List<QueryParam> attributes) {
        ArrayList<QueryParam> translated = new ArrayList<QueryParam>();
        for (QueryParam entry : attributes) {
            translated.add(new QueryParam(translationTable.get(entry.getColumn()), entry.getOperator(), entry.getValue()));
        }
        return translated;
    }
}

