/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.store;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.kie.services.api.AttributesAware;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.kie.services.impl.store.DeploymentStoreEntry;
import org.jbpm.kie.services.impl.store.TransientObjectConverter;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.jbpm.shared.services.impl.commands.MergeObjectCommand;
import org.jbpm.shared.services.impl.commands.PersistObjectCommand;
import org.jbpm.shared.services.impl.commands.QueryNameCommand;
import org.kie.api.command.Command;
import org.kie.soup.commons.xstream.XStreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentStore {
    private static final Integer STATE_DISABLED = 0;
    private static final Integer STATE_ENABLED = 1;
    private static final Integer STATE_ACTIVATED = 2;
    private static final Integer STATE_DEACTIVATED = 3;
    private static final Integer STATE_OBSOLETE = -1;
    private static final Logger logger = LoggerFactory.getLogger(DeploymentStore.class);
    private final XStream xstream = XStreamUtils.createXStream();
    private TransactionalCommandService commandService;

    public DeploymentStore() {
        String[] voidDeny = new String[]{"void.class", "Void.class"};
        this.xstream.denyTypes(voidDeny);
        this.xstream.registerConverter((Converter)new TransientObjectConverter());
    }

    public void setCommandService(TransactionalCommandService commandService) {
        this.commandService = commandService;
    }

    public Collection<DeploymentUnit> getEnabledDeploymentUnits() {
        ArrayList<DeploymentUnit> activeDeployments = new ArrayList<DeploymentUnit>();
        HashMap params = new HashMap();
        ArrayList<Integer> states = new ArrayList<Integer>();
        states.add(STATE_ENABLED);
        states.add(STATE_ACTIVATED);
        states.add(STATE_DEACTIVATED);
        params.put("state", states);
        List deployments = (List)this.commandService.execute((Command)new QueryNameCommand("getDeploymentUnitsByState", params));
        for (DeploymentStoreEntry entry : deployments) {
            String sync = this.getEntryAttributes(entry.getAttributes()).get("sync");
            if (sync != null && !sync.equalsIgnoreCase("true")) continue;
            DeploymentUnit unit = (DeploymentUnit)this.xstream.fromXML(entry.getDeploymentUnit());
            if (entry.getState() == STATE_DEACTIVATED) {
                ((KModuleDeploymentUnit)unit).setActive(false);
            }
            activeDeployments.add(unit);
        }
        return activeDeployments;
    }

    public Collection<DeploymentUnit> getDeactivatedDeploymentUnits() {
        ArrayList<DeploymentUnit> activeDeployments = new ArrayList<DeploymentUnit>();
        HashMap params = new HashMap();
        ArrayList<Integer> states = new ArrayList<Integer>();
        states.add(STATE_DEACTIVATED);
        params.put("state", states);
        List deployments = (List)this.commandService.execute((Command)new QueryNameCommand("getDeploymentUnitsByState", params));
        for (DeploymentStoreEntry entry : deployments) {
            String sync = this.getEntryAttributes(entry.getAttributes()).get("sync");
            if (sync != null && !sync.equalsIgnoreCase("true")) continue;
            DeploymentUnit unit = (DeploymentUnit)this.xstream.fromXML(entry.getDeploymentUnit());
            ((KModuleDeploymentUnit)unit).setActive(false);
            activeDeployments.add(unit);
        }
        return activeDeployments;
    }

    public void getDeploymentUnitsByDate(Date date, Collection<DeploymentUnit> enabled, Collection<DeploymentUnit> disabled, Collection<DeploymentUnit> activated, Collection<DeploymentUnit> deactivated) {
        HashMap<String, Date> params = new HashMap<String, Date>();
        params.put("ludate", date);
        List deployments = (List)this.commandService.execute((Command)new QueryNameCommand("getDeploymentUnitsByDate", params));
        for (DeploymentStoreEntry entry : deployments) {
            String sync = this.getEntryAttributes(entry.getAttributes()).get("sync");
            if (sync != null && !sync.equalsIgnoreCase("true")) continue;
            DeploymentUnit unit = (DeploymentUnit)this.xstream.fromXML(entry.getDeploymentUnit());
            if (entry.getState() == STATE_ENABLED) {
                enabled.add(unit);
                continue;
            }
            if (entry.getState() == STATE_DISABLED) {
                disabled.add(unit);
                continue;
            }
            if (entry.getState() == STATE_ACTIVATED) {
                activated.add(unit);
                continue;
            }
            if (entry.getState() == STATE_DEACTIVATED) {
                ((KModuleDeploymentUnit)unit).setActive(false);
                deactivated.add(unit);
                continue;
            }
            logger.warn("Unknown state of deployment store entry {} for {} will be ignored", (Object)entry.getId(), (Object)entry);
        }
    }

    public void enableDeploymentUnit(DeploymentUnit unit) {
        String unitContent = this.xstream.toXML((Object)unit);
        DeploymentStoreEntry entry = this.findDeploymentStoreByDeploymentId(unit.getIdentifier());
        if (entry != null) {
            entry.setState(STATE_ENABLED);
            entry.setUpdateDate(new Date());
            entry.setDeploymentUnit(unitContent);
            this.commandService.execute((Command)new MergeObjectCommand(new Object[]{entry}));
            return;
        }
        entry = new DeploymentStoreEntry();
        entry.setDeploymentId(unit.getIdentifier());
        entry.setState(STATE_ENABLED);
        entry.setUpdateDate(new Date());
        entry.setDeploymentUnit(unitContent);
        if (unit instanceof AttributesAware) {
            String attribtues = this.buildEntryAttributes(((AttributesAware)unit).getAttributes());
            entry.setAttributes(attribtues);
        }
        this.commandService.execute((Command)new PersistObjectCommand(new Object[]{entry}));
    }

    public void disableDeploymentUnit(DeploymentUnit unit) {
        DeploymentStoreEntry entry = this.findDeploymentStoreByDeploymentId(unit.getIdentifier());
        if (entry != null) {
            entry.setState(STATE_DISABLED);
            entry.setUpdateDate(new Date());
            this.commandService.execute((Command)new MergeObjectCommand(new Object[]{entry}));
        }
    }

    public void deactivateDeploymentUnit(DeploymentUnit unit) {
        DeploymentStoreEntry entry = this.findDeploymentStoreByDeploymentId(unit.getIdentifier());
        if (entry != null && entry.getState() != STATE_DEACTIVATED) {
            entry.setState(STATE_DEACTIVATED);
            entry.setUpdateDate(new Date());
            this.commandService.execute((Command)new MergeObjectCommand(new Object[]{entry}));
        }
    }

    public void activateDeploymentUnit(DeploymentUnit unit) {
        DeploymentStoreEntry entry = this.findDeploymentStoreByDeploymentId(unit.getIdentifier());
        if (entry != null && entry.getState() != STATE_ACTIVATED) {
            entry.setState(STATE_ACTIVATED);
            entry.setUpdateDate(new Date());
            this.commandService.execute((Command)new MergeObjectCommand(new Object[]{entry}));
        }
    }

    public void markDeploymentUnitAsObsolete(DeploymentUnit unit) {
        DeploymentStoreEntry entry = this.findDeploymentStoreByDeploymentId(unit.getIdentifier());
        if (entry != null) {
            entry.setState(STATE_OBSOLETE);
            entry.setUpdateDate(new Date());
            this.commandService.execute((Command)new MergeObjectCommand(new Object[]{entry}));
        }
    }

    public DeploymentStoreEntry findDeploymentStoreByDeploymentId(String deploymentId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("deploymentId", deploymentId);
        params.put("maxResults", 1);
        List deployments = (List)this.commandService.execute((Command)new QueryNameCommand("getDeploymentUnit", params));
        if (!deployments.isEmpty()) {
            return (DeploymentStoreEntry)deployments.get(0);
        }
        return null;
    }

    protected Map<String, String> getEntryAttributes(String attributes) {
        logger.debug("Reading attributes string {}", (Object)attributes);
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        if (attributes != null && !attributes.trim().isEmpty()) {
            String[] pairs;
            for (String pair : pairs = attributes.split(";")) {
                String[] keyValue = pair.split("=");
                if (keyValue.length == 2) {
                    attributeMap.put(keyValue[0], keyValue[1]);
                    continue;
                }
                if (keyValue.length != 1) continue;
                attributeMap.put(keyValue[0], "");
            }
        }
        return attributeMap;
    }

    protected String buildEntryAttributes(Map<String, String> attributes) {
        StringBuilder builder = new StringBuilder();
        if (attributes != null && !attributes.isEmpty()) {
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                builder.append(entry.getKey() + "=" + entry.getValue() + ";");
            }
            builder.deleteCharAt(builder.length() - 1);
        }
        logger.debug("Built attributes as string {}", (Object)builder);
        return builder.toString();
    }
}

