/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.kie.services.impl.VariablesAware;
import org.jbpm.services.api.AdHocUserTaskService;
import org.jbpm.services.task.utils.TaskFluent;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.InternalTaskService;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.model.InternalI18NText;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdHocUserTaskServiceImpl
implements AdHocUserTaskService,
VariablesAware {
    private static final Logger logger = LoggerFactory.getLogger(AdHocUserTaskServiceImpl.class);
    private InternalTaskService nonProcessScopedTaskService;

    public void setNonProcessScopedTaskService(InternalTaskService nonProcessScopedTaskService) {
        this.nonProcessScopedTaskService = nonProcessScopedTaskService;
    }

    protected InternalTaskService getInternalTaskService() {
        return this.nonProcessScopedTaskService;
    }

    public long addTask(String taskName, int priority, Date dueDate, List<String> users, List<String> groups, String identity, String taskformName, String deploymentId, Long processInstanceId, Map<String, Object> params, boolean autoStart, boolean autoClaim) {
        TaskFluent taskFluent = new TaskFluent().setName(taskName).setPriority(priority).setDueDate(dueDate).setFormName(taskformName);
        if (deploymentId != null && !deploymentId.equals("")) {
            taskFluent.setDeploymentID(deploymentId);
        } else {
            taskFluent.setDeploymentID(null);
        }
        if (processInstanceId > 0L) {
            taskFluent.setProcessInstanceId(processInstanceId.longValue());
        }
        for (String user : users) {
            taskFluent.addPotentialUser(user);
        }
        for (String group : groups) {
            taskFluent.addPotentialGroup(group);
        }
        taskFluent.setAdminUser("Administrator");
        taskFluent.setAdminGroup("Administrators");
        Task task = taskFluent.getTask();
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        long taskId = this.nonProcessScopedTaskService.addTask(taskFluent.getTask(), params);
        if (autoStart) {
            this.nonProcessScopedTaskService.start(taskId, identity);
        }
        if (autoClaim) {
            this.nonProcessScopedTaskService.claim(taskId, identity);
        }
        return taskId;
    }

    public void updateTask(long taskId, int priority, String taskDescription, Date dueDate) {
        this.nonProcessScopedTaskService.setPriority(taskId, priority);
        if (taskDescription != null) {
            InternalI18NText text = (InternalI18NText)TaskModelProvider.getFactory().newI18NText();
            text.setLanguage("en-UK");
            text.setText(taskDescription);
            ArrayList<InternalI18NText> names = new ArrayList<InternalI18NText>();
            names.add(text);
            this.nonProcessScopedTaskService.setDescriptions(taskId, names);
        }
        if (dueDate != null) {
            this.nonProcessScopedTaskService.setExpirationDate(taskId, dueDate);
        }
    }

    @Override
    public <T> T process(T variables, ClassLoader cl) {
        return variables;
    }

    public long addTask(Task task, Map<String, Object> params) {
        return this.nonProcessScopedTaskService.addTask(task, params);
    }
}

