/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.api.integration.base;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jbpm.persistence.api.integration.EventCollection;
import org.jbpm.persistence.api.integration.InstanceView;

public class BaseEventCollection
implements EventCollection {
    private static final long serialVersionUID = -5241582057875657702L;
    private Map<InstanceView<?>, InstanceView<?>> eventsMap = new LinkedHashMap();

    @Override
    public void update(InstanceView<?> item) {
        this.eventsMap.put(item, item);
    }

    @Override
    public void remove(InstanceView<?> item) {
        this.eventsMap.put(item, item);
    }

    @Override
    public Collection<InstanceView<?>> getEvents() {
        return this.eventsMap.values();
    }

    @Override
    public void add(InstanceView<?> event) {
        this.eventsMap.put(event, event);
    }

    private void readObject(ObjectInputStream input) throws ClassNotFoundException, IOException {
        Object collection = input.readObject();
        if (collection instanceof Set) {
            this.eventsMap = new LinkedHashMap();
            for (InstanceView event : (Set)collection) {
                this.eventsMap.put(event, event);
            }
        } else {
            this.eventsMap = (Map)collection;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.eventsMap);
    }
}

