/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.processes.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import java.util.List;
import java.util.Optional;
import org.kie.kogito.quarkus.processes.devservices.DevModeWorkflowLogger;
import org.kie.kogito.quarkus.workflow.deployment.AbstractDevServicesProcessor;
import org.kie.kogito.quarkus.workflow.deployment.config.KogitoWorkflowBuildTimeConfig;

public class KogitoDevServicesProcessor
extends AbstractDevServicesProcessor {
    @BuildStep
    public void logger(BuildProducer<AdditionalBeanBuildItem> additionalBean, LaunchModeBuildItem launchMode, KogitoWorkflowBuildTimeConfig config) {
        if (KogitoDevServicesProcessor.shouldInclude((LaunchModeBuildItem)launchMode, (KogitoWorkflowBuildTimeConfig)config)) {
            additionalBean.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(DevModeWorkflowLogger.class).setUnremovable().setDefaultScope(DotNames.APPLICATION_SCOPED).build());
        }
    }

    @BuildStep(onlyIf={GlobalDevServicesConfig.Enabled.class, IsDevelopment.class})
    CardPageBuildItem createDataIndexDevUILink(Capabilities capabilities, KogitoWorkflowBuildTimeConfig kogitoBuildTimeConfig, List<SystemPropertyBuildItem> systemPropertyBuildItems) {
        Optional dataIndexUrlProp = this.getProperty(systemPropertyBuildItems, "kogito.data-index.url");
        if (capabilities.isPresent("org.kie.kogito.data-index") || !this.areDevServicesEnabled(kogitoBuildTimeConfig) || dataIndexUrlProp.isEmpty()) {
            return null;
        }
        CardPageBuildItem cardPageBuildItem = new CardPageBuildItem();
        cardPageBuildItem.addPage((PageBuilder)Page.externalPageBuilder((String)"Data Index GraphQL UI").url((String)dataIndexUrlProp.get() + "/q/graphql-ui/").isHtmlContent().icon("font-awesome-solid:signs-post"));
        return cardPageBuildItem;
    }

    private boolean areDevServicesEnabled(KogitoWorkflowBuildTimeConfig kogitoBuildTimeConfig) {
        return kogitoBuildTimeConfig.devservices.enabled.orElse(true);
    }
}

