/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.quarkus.devui.runtime.rpc;

import io.quarkus.arc.profile.IfBuildProfile;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.Collection;
import java.util.Objects;
import org.kie.kogito.event.DataEvent;
import org.kie.kogito.event.EventPublisher;

@ApplicationScoped
@IfBuildProfile(value="dev")
public class JBPMDevUIEventPublisher
implements EventPublisher {
    private Runnable onProcessEvent;
    private Runnable onTaskEvent;
    private Runnable onJobEvent;

    public void publish(DataEvent<?> event) {
        switch (event.getType()) {
            case "ProcessInstanceStateDataEvent": {
                this.maybeRun(this.onProcessEvent);
                break;
            }
            case "UserTaskInstanceStateDataEvent": {
                this.maybeRun(this.onTaskEvent);
                break;
            }
            case "JobEvent": {
                this.maybeRun(this.onJobEvent);
            }
        }
    }

    public void publish(Collection<DataEvent<?>> events) {
        events.forEach(this::publish);
    }

    private void maybeRun(Runnable runnable) {
        if (Objects.nonNull(runnable)) {
            runnable.run();
        }
    }

    public void setOnProcessEventListener(Runnable onProcessEvent) {
        this.onProcessEvent = onProcessEvent;
    }

    public void setOnTaskEventListener(Runnable onTaskEvent) {
        this.onTaskEvent = onTaskEvent;
    }

    public void setOnJobEventListener(Runnable onJobEvent) {
        this.onJobEvent = onJobEvent;
    }
}

