/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.query.jpa.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jbpm.query.jpa.data.QueryWhere;

@XmlRootElement
@XmlType
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonIgnoreProperties(value={"parameters"})
public class QueryCriteria {
    @XmlAttribute
    private String listId;
    @XmlAttribute
    private boolean union = true;
    @XmlAttribute
    private boolean first = false;
    @XmlAttribute
    private QueryWhere.QueryCriteriaType type = QueryWhere.QueryCriteriaType.NORMAL;
    @XmlElement(name="parameter")
    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="class")
    private List<Object> values;
    @XmlElement(name="date-parameter")
    private List<Date> dateValues;
    @XmlElement
    private List<QueryCriteria> criteria;
    private static SimpleDateFormat toStringSdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public QueryCriteria() {
    }

    public QueryCriteria(boolean union) {
        this.union = union;
        this.type = QueryWhere.QueryCriteriaType.GROUP;
    }

    private QueryCriteria(String listId, QueryWhere.QueryCriteriaType type) {
        this.listId = listId;
        this.type = type;
    }

    public QueryCriteria(String listId, boolean union, QueryWhere.QueryCriteriaType type, int valueListSize) {
        this(listId, type);
        this.union = union;
        this.values = new ArrayList<Object>(valueListSize);
    }

    public String getListId() {
        return this.listId;
    }

    public void setListId(String listId) {
        this.listId = listId;
    }

    public boolean isUnion() {
        return this.union;
    }

    public void setUnion(boolean union) {
        this.union = union;
    }

    public boolean isFirst() {
        return this.first;
    }

    public void setFirst(boolean first) {
        this.first = first;
    }

    public QueryWhere.QueryCriteriaType getType() {
        return this.type;
    }

    public void setType(QueryWhere.QueryCriteriaType type) {
        this.type = type;
    }

    public List<Object> getValues() {
        if (this.values == null) {
            this.values = new ArrayList<Object>();
        }
        return this.values;
    }

    public void setValues(List<Object> values) {
        this.values = values;
    }

    public List<Date> getDateValues() {
        if (this.dateValues == null) {
            this.dateValues = new ArrayList<Date>();
        }
        return this.dateValues;
    }

    public void setDateValues(List<Date> dateValues) {
        this.dateValues = dateValues;
    }

    @JsonIgnore
    public boolean isGroupCriteria() {
        return this.type.equals((Object)QueryWhere.QueryCriteriaType.GROUP);
    }

    @JsonIgnore
    public boolean hasValues() {
        return this.values != null && !this.values.isEmpty();
    }

    @JsonIgnore
    public boolean hasDateValues() {
        return this.dateValues != null && !this.dateValues.isEmpty();
    }

    @JsonIgnore
    public boolean hasCriteria() {
        return this.criteria != null && !this.criteria.isEmpty();
    }

    public List<QueryCriteria> getCriteria() {
        if (this.criteria == null) {
            this.criteria = new ArrayList<QueryCriteria>();
        }
        return this.criteria;
    }

    public void setCriteria(List<QueryCriteria> criteria) {
        this.criteria = criteria;
    }

    public List<Object> getParameters() {
        ArrayList<Object> parameters = new ArrayList<Object>(this.getValues());
        if (this.dateValues != null && !this.dateValues.isEmpty()) {
            parameters.addAll(this.dateValues);
        }
        if (parameters.isEmpty()) {
            return parameters;
        }
        return parameters;
    }

    void addParameter(Object value) {
        if (value instanceof Date) {
            this.getDateValues().add((Date)value);
        } else {
            this.getValues().add(value);
        }
    }

    void setParameter(int index, Object value, int listSize) {
        List<Object> addValues = value instanceof Date ? this.getDateValues() : this.getValues();
        while (addValues.size() <= index) {
            addValues.add(null);
        }
        addValues.set(index, value);
        while (addValues.size() < listSize) {
            addValues.add(null);
        }
    }

    public void addCriteria(QueryCriteria criteria) {
        this.getCriteria().add(criteria);
    }

    public QueryCriteria(QueryCriteria queryCriteria) {
        this.listId = queryCriteria.listId;
        this.union = queryCriteria.union;
        this.first = queryCriteria.first;
        this.type = queryCriteria.type;
        if (queryCriteria.values != null) {
            this.values = new ArrayList<Object>(queryCriteria.values);
        }
        if (queryCriteria.dateValues != null) {
            this.dateValues = new ArrayList<Date>(queryCriteria.dateValues);
        }
        if (queryCriteria.criteria != null) {
            this.criteria = new ArrayList<QueryCriteria>(queryCriteria.criteria);
        }
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        if (!this.first) {
            out.append(this.union ? "OR" : "AND").append(" ");
        }
        if (this.listId != null) {
            out.append(this.listId);
        }
        if (this.values != null && !this.values.isEmpty()) {
            out.append(" =");
            if (this.type.equals((Object)QueryWhere.QueryCriteriaType.REGEXP)) {
                out.append("~");
            }
            out.append(" ");
            if (this.type.equals((Object)QueryWhere.QueryCriteriaType.RANGE)) {
                out.append("[");
            }
            out.append(this.values.get(0));
            for (int i = 1; i < this.values.size(); ++i) {
                out.append(", ").append(this.values.get(i));
            }
            if (this.type.equals((Object)QueryWhere.QueryCriteriaType.RANGE)) {
                out.append("]");
            }
        } else if (this.dateValues != null && !this.dateValues.isEmpty()) {
            Date date;
            out.append(" =");
            if (this.type.equals((Object)QueryWhere.QueryCriteriaType.REGEXP)) {
                out.append("~");
            }
            out.append(" ");
            if (this.type.equals((Object)QueryWhere.QueryCriteriaType.RANGE)) {
                out.append("[");
            }
            String dateStr = (date = this.dateValues.get(0)) != null ? toStringSdf.format(date) : "null";
            out.append(dateStr);
            for (int i = 1; i < this.dateValues.size(); ++i) {
                date = this.dateValues.get(i);
                dateStr = date != null ? toStringSdf.format(date) : "null";
                out.append(", ").append(dateStr);
            }
            if (this.type.equals((Object)QueryWhere.QueryCriteriaType.RANGE)) {
                out.append("]");
            }
        }
        if (this.criteria != null) {
            if (out.length() > 0) {
                out.append(" ");
            }
            out.append("(");
            int size = this.criteria.size();
            if (size > 0) {
                out.append(this.criteria.get(0).toString());
            }
            for (int i = 1; i < size; ++i) {
                out.append(", ");
                out.append(this.criteria.get(i).toString());
            }
            out.append(")");
        }
        return out.toString();
    }
}

