/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.deploy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jbpm.runtime.manager.impl.SimpleRegisterableItemsFactory;
import org.jbpm.runtime.manager.util.TestUtil;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.DefaultAgendaEventListener;
import org.kie.api.event.rule.DefaultRuleRuntimeEventListener;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.kie.internal.runtime.manager.SecurityManager;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.internal.task.api.UserGroupCallback;
import org.kie.test.util.db.PoolingDataSourceWrapper;

public class SecurityManagerTest
extends AbstractBaseTest {
    private PoolingDataSourceWrapper pds;
    private UserGroupCallback userGroupCallback;
    private RuntimeManager manager;

    @Before
    public void setup() {
        TestUtil.cleanupSingletonSessionId();
        this.pds = TestUtil.setupPoolingDataSource();
        Properties properties = new Properties();
        properties.setProperty("mary", "HR");
        properties.setProperty("john", "HR");
        this.userGroupCallback = new JBossUserGroupCallbackImpl(properties);
    }

    @After
    public void teardown() {
        if (this.manager != null) {
            this.manager.close();
        }
        this.pds.close();
    }

    @Test
    public void testNoSecurityManager() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newEmptyBuilder().userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        Assert.assertNotNull((Object)runtime);
        this.manager.disposeRuntimeEngine(runtime);
    }

    @Test(expected=SecurityException.class)
    public void testDenyAllSecurityManager() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newEmptyBuilder().userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        ((InternalRuntimeManager)this.manager).setSecurityManager(new SecurityManager(){

            public void checkPermission() throws SecurityException {
                throw new SecurityException("Deny all on purpose");
            }
        });
        this.manager.getRuntimeEngine(EmptyContext.get()).getKieSession();
    }

    @Test(expected=SecurityException.class)
    public void testCustomSecurityManager() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newEmptyBuilder().userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).get();
        this.manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        final User user = new User("john");
        ((InternalRuntimeManager)this.manager).setSecurityManager(new SecurityManager(){

            public void checkPermission() throws SecurityException {
                if ("mary".equals(user.getName())) {
                    throw new SecurityException("Mary is not allowed to use runtime manager");
                }
            }
        });
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        Assert.assertNotNull((Object)runtime);
        this.manager.disposeRuntimeEngine(runtime);
        user.setName("mary");
        this.manager.getRuntimeEngine(EmptyContext.get()).getKieSession();
    }

    @Test(expected=IllegalStateException.class)
    public void testNoSessionAfterDispose() {
        DefaultProcessEventListener processListener = new DefaultProcessEventListener();
        DefaultAgendaEventListener agendaListener = new DefaultAgendaEventListener();
        DefaultRuleRuntimeEventListener workingMemoryListener = new DefaultRuleRuntimeEventListener();
        HashMap<String, Object> globals = new HashMap<String, Object>();
        ArrayList list = new ArrayList();
        globals.put("list", list);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newEmptyBuilder().userGroupCallback((org.kie.api.task.UserGroupCallback)this.userGroupCallback).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-BusinessRuleTaskWithGlobal.drl"), ResourceType.DRL).registerableItemsFactory((RegisterableItemsFactory)new TestRegisterableItemsFactory((ProcessEventListener)processListener, (AgendaEventListener)agendaListener, (RuleRuntimeEventListener)workingMemoryListener, globals)).get();
        this.manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        Assert.assertNotNull((Object)this.manager);
        RuntimeEngine runtime = this.manager.getRuntimeEngine(EmptyContext.get());
        Assert.assertNotNull((Object)runtime);
        this.manager.disposeRuntimeEngine(runtime);
        runtime.getKieSession();
    }

    private class TestRegisterableItemsFactory
    extends SimpleRegisterableItemsFactory {
        private ProcessEventListener plistener;
        private AgendaEventListener alistener;
        private RuleRuntimeEventListener rlistener;
        private Map<String, Object> globals;

        public TestRegisterableItemsFactory(ProcessEventListener listener, AgendaEventListener alistener, RuleRuntimeEventListener rlistener, Map<String, Object> globals) {
            this.plistener = listener;
            this.alistener = alistener;
            this.rlistener = rlistener;
            this.globals = globals;
        }

        public Map<String, WorkItemHandler> getWorkItemHandlers(RuntimeEngine runtime) {
            Map handlers = super.getWorkItemHandlers(runtime);
            handlers.put("MyWIH", new WorkItemHandler(){

                public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
                }

                public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
                }
            });
            return handlers;
        }

        public List<ProcessEventListener> getProcessEventListeners(RuntimeEngine runtime) {
            List listeners = super.getProcessEventListeners(runtime);
            if (this.plistener != null) {
                listeners.addAll(Arrays.asList(this.plistener));
            }
            return listeners;
        }

        public List<AgendaEventListener> getAgendaEventListeners(RuntimeEngine runtime) {
            List alisteners = super.getAgendaEventListeners(runtime);
            if (this.alistener != null) {
                alisteners.addAll(Arrays.asList(this.alistener));
            }
            return alisteners;
        }

        public List<RuleRuntimeEventListener> getRuleRuntimeEventListeners(RuntimeEngine runtime) {
            List rlisteners = super.getRuleRuntimeEventListeners(runtime);
            if (this.rlistener != null) {
                rlisteners.addAll(Arrays.asList(this.rlistener));
            }
            return rlisteners;
        }

        public Map<String, Object> getGlobals(RuntimeEngine runtime) {
            Map rglobals = super.getGlobals(runtime);
            if (rglobals != null) {
                rglobals.putAll(this.globals);
            }
            return this.globals;
        }
    }

    private class User {
        private String name;

        User(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

