/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.util;

import java.io.File;
import org.jbpm.test.persistence.util.PersistenceUtil;
import org.junit.Assert;
import org.kie.test.util.db.PoolingDataSourceWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUtil {
    private static final Logger logger = LoggerFactory.getLogger(TestUtil.class);

    public static PoolingDataSourceWrapper setupPoolingDataSource() {
        return PersistenceUtil.setupPoolingDataSource((String)"jdbc/jbpm-ds");
    }

    public static void cleanupSingletonSessionId() {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        if (tempDir.exists()) {
            String[] jbpmSerFiles;
            for (String file : jbpmSerFiles = tempDir.list((dir, name) -> name.endsWith("-jbpmSessionId.ser"))) {
                logger.debug("Temp dir to be removed {} file {}", (Object)tempDir, (Object)file);
                new File(tempDir, file).delete();
            }
        }
    }

    public static void main(String[] args) {
        TestUtil.cleanupSingletonSessionId();
    }

    public static void checkDisposedSessionException(Throwable e) {
        Throwable rootCause;
        for (rootCause = e.getCause(); rootCause != null && rootCause.getCause() != null; rootCause = rootCause.getCause()) {
        }
        if (!(rootCause instanceof IllegalStateException)) {
            Assert.fail((String)("Unexpected exception caught " + rootCause.getMessage()));
        }
    }
}

