/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.jpa;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="TimerMappingInfo", indexes={@Index(name="IDX_TMI_KSessionUUID", unique=true, columnList="kieSessionId,uuid")})
@SequenceGenerator(name="timerMappingInfoIdSeq", sequenceName="TIMER_MAPPING_INFO_ID_SEQ")
public class TimerMappingInfo
implements Serializable {
    private static final long serialVersionUID = 533985957655465840L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="timerMappingInfoIdSeq")
    private Long id;
    private Long timerId;
    private String externalTimerId;
    private long kieSessionId;
    private Long processInstanceId;
    @Column(nullable=false)
    private String uuid;
    @Lob
    @Column(length=0x7FFFFFFF)
    private byte[] info;

    public TimerMappingInfo() {
    }

    public TimerMappingInfo(Long timerId, String externalTimerId, long kieSessionId, String uuid) {
        this.timerId = timerId;
        this.externalTimerId = externalTimerId;
        this.kieSessionId = kieSessionId;
        this.uuid = uuid;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getExternalTimerId() {
        return this.externalTimerId;
    }

    public void setExternalTimerId(String externalTimerId) {
        this.externalTimerId = externalTimerId;
    }

    public long getKieSessionId() {
        return this.kieSessionId;
    }

    public void setKieSessionId(long kieSessionId) {
        this.kieSessionId = kieSessionId;
    }

    public Long getTimerId() {
        return this.timerId;
    }

    public void setTimerId(Long timerId) {
        this.timerId = timerId;
    }

    public byte[] getInfo() {
        return this.info;
    }

    public void setInfo(byte[] info) {
        this.info = info;
    }

    public Long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(Long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.info);
        result = 31 * result + Objects.hash(this.externalTimerId, this.id, this.kieSessionId, this.processInstanceId, this.timerId, this.uuid);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimerMappingInfo other = (TimerMappingInfo)obj;
        return Objects.equals(this.externalTimerId, other.externalTimerId) && Objects.equals(this.id, other.id) && Arrays.equals(this.info, other.info) && this.kieSessionId == other.kieSessionId && Objects.equals(this.processInstanceId, other.processInstanceId) && Objects.equals(this.timerId, other.timerId) && Objects.equals(this.uuid, other.uuid);
    }

    public String toString() {
        return "TimerMappingInfo [id=" + this.id + ", timerId=" + this.timerId + ", externalTimerId=" + this.externalTimerId + ", kieSessionId=" + this.kieSessionId + ", processInstanceId=" + this.processInstanceId + ", uuid=" + this.uuid + ", info=" + Arrays.toString(this.info) + "]";
    }
}

