/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.cdi.impl.store;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.naming.InitialContext;
import org.jbpm.kie.services.impl.store.DeploymentStore;
import org.jbpm.kie.services.impl.store.DeploymentSyncInvoker;
import org.jbpm.kie.services.impl.store.DeploymentSynchronizer;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.shared.services.impl.TransactionalCommandService;
import org.kie.internal.runtime.cdi.BootOnLoad;

@BootOnLoad
@ApplicationScoped
public class DeploymentSyncManager {
    @Inject
    private DeploymentService deploymentService;
    @Inject
    private TransactionalCommandService commandService;
    private DeploymentSyncInvoker invoker;
    private DeploymentSynchronizer synchronizer;

    @PostConstruct
    public void configureAndStart() {
        try {
            InitialContext.doLookup("java:module/DeploymentSynchronizerCDInvoker");
        }
        catch (Exception e) {
            DeploymentStore store = new DeploymentStore();
            store.setCommandService(this.commandService);
            this.synchronizer = new DeploymentSynchronizer();
            this.synchronizer.setDeploymentService(this.deploymentService);
            this.synchronizer.setDeploymentStore(store);
            this.invoker = new DeploymentSyncInvoker(this.synchronizer);
            this.invoker.start();
        }
    }

    @PreDestroy
    public void cleanup() {
        if (this.invoker != null) {
            this.invoker.stop();
        }
    }
}

