/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.cdi.producer;

import java.util.HashSet;
import javax.enterprise.inject.AmbiguousResolutionException;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;
import org.jbpm.services.task.HumanTaskConfigurator;
import org.jbpm.services.task.HumanTaskServiceFactory;
import org.jbpm.services.task.impl.command.CommandBasedTaskService;
import org.kie.api.task.TaskLifeCycleEventListener;
import org.kie.api.task.UserGroupCallback;
import org.kie.internal.task.api.InternalTaskService;
import org.kie.internal.task.api.UserInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HumanTaskServiceProducer {
    private static final Logger logger = LoggerFactory.getLogger(HumanTaskServiceProducer.class);
    final String mode = System.getProperty("org.jbpm.cdi.taskservice.mode", "new");
    @Inject
    private Instance<UserGroupCallback> userGroupCallback;
    @Inject
    private Instance<UserInfo> userInfo;
    @Inject
    @Any
    private Instance<TaskLifeCycleEventListener> taskListeners;
    @Inject
    @PersistenceUnit(unitName="org.jbpm.domain")
    private EntityManagerFactory emf;
    private InternalTaskService taskService;

    @Produces
    public CommandBasedTaskService produceTaskService() {
        if (this.mode.equalsIgnoreCase("none")) {
            return null;
        }
        if (this.taskService == null) {
            HumanTaskConfigurator configurator = HumanTaskServiceFactory.newTaskServiceConfigurator().entityManagerFactory(this.emf).userGroupCallback(this.safeGet(this.userGroupCallback)).userInfo(this.safeGet(this.userInfo));
            try {
                for (TaskLifeCycleEventListener listener : this.taskListeners) {
                    configurator.listener(listener);
                    logger.debug("Registering listener {}", (Object)listener);
                }
            }
            catch (Exception e) {
                logger.debug("Cannot add listeners to task service due to {}", (Object)e.getMessage());
            }
            if (this.mode.equalsIgnoreCase("singleton")) {
                this.taskService = (CommandBasedTaskService)configurator.getTaskService();
            } else {
                return (CommandBasedTaskService)configurator.getTaskService();
            }
        }
        return (CommandBasedTaskService)this.taskService;
    }

    protected <T> T safeGet(Instance<T> instance) {
        try {
            Object object = instance.get();
            logger.debug("About to set object {} on task service", object);
            return (T)object;
        }
        catch (AmbiguousResolutionException e) {
            HashSet available = new HashSet();
            for (Object object : instance) {
                available.add(object);
            }
            if (available.size() == 1) {
                return (T)available.iterator().next();
            }
            throw e;
        }
        catch (Throwable e) {
            logger.debug("Cannot get value of of instance {} due to {}", instance, (Object)e.getMessage());
            return null;
        }
    }
}

