/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.shared.services.impl.events;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.event.Event;
import javax.enterprise.util.TypeLiteral;
import org.jboss.solder.core.Veto;
import org.jbpm.shared.services.impl.events.JbpmServicesEventListener;

@Veto
public class JbpmServicesEventImpl<T>
implements Event<T>,
Serializable {
    List<JbpmServicesEventListener> listeners = new CopyOnWriteArrayList<JbpmServicesEventListener>();
    private List<String> filters = new CopyOnWriteArrayList<String>();

    public void fire(T t) {
        ConcurrentHashMap invokeMethods = new ConcurrentHashMap();
        for (JbpmServicesEventListener jbpmServicesEventListener : this.listeners) {
            Map<Method, List<Annotation>> observerMethods = jbpmServicesEventListener.getObserverMethods();
            for (Method m : observerMethods.keySet()) {
                for (Annotation a : observerMethods.get(m)) {
                    boolean filtered = false;
                    for (String filter : this.filters) {
                        if (!a.annotationType().getCanonicalName().equals(filter)) continue;
                        filtered = true;
                    }
                    if (!filtered) continue;
                    if (invokeMethods.get(jbpmServicesEventListener) == null) {
                        invokeMethods.put(jbpmServicesEventListener, new CopyOnWriteArrayList());
                    }
                    ((List)invokeMethods.get(jbpmServicesEventListener)).add(m);
                }
            }
        }
        this.filters.clear();
        for (JbpmServicesEventListener<Object> jbpmServicesEventListener : invokeMethods.keySet()) {
            for (Method m : (List)invokeMethods.get(jbpmServicesEventListener)) {
                try {
                    m.invoke(jbpmServicesEventListener, t);
                }
                catch (IllegalAccessException ex) {
                    Logger.getLogger(JbpmServicesEventImpl.class.getName()).log(Level.SEVERE, null, ex);
                    throw new RuntimeException(ex.getCause());
                }
                catch (IllegalArgumentException ex) {
                    Logger.getLogger(JbpmServicesEventImpl.class.getName()).log(Level.SEVERE, null, ex);
                    throw new RuntimeException(ex.getCause());
                }
                catch (InvocationTargetException ex) {
                    Logger.getLogger(JbpmServicesEventImpl.class.getName()).log(Level.SEVERE, null, ex);
                    throw new RuntimeException(ex.getCause());
                }
            }
        }
        invokeMethods.clear();
    }

    public boolean addListener(JbpmServicesEventListener e) {
        return this.listeners.add(e);
    }

    public void clearListeners() {
        this.listeners.clear();
    }

    public List<JbpmServicesEventListener> getListeners() {
        return this.listeners;
    }

    public Event<T> select(Annotation ... antns) {
        for (Annotation a : antns) {
            this.filters.add(a.annotationType().getCanonicalName());
        }
        return this;
    }

    public <U extends T> Event<U> select(Class<U> type, Annotation ... antns) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public <U extends T> Event<U> select(TypeLiteral<U> tl, Annotation ... antns) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

