/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.gateway;

import java.util.ArrayList;
import org.drools.core.time.SessionPseudoClock;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.listener.TrackingProcessEventListener;
import org.jbpm.test.tools.TrackingListenerAssert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.command.CommandFactory;

public class EventBasedGatewayTest
extends JbpmTestCase {
    private static final String EVENT_BASED_GATEWAY = "org/jbpm/test/functional/gateway/EventBasedGateway.bpmn";
    private static final String EVENT_BASED_GATEWAY_ID = "org.jbpm.test.functional.gateway.EventBasedGateway";
    private KieSession ksession;

    public EventBasedGatewayTest() {
        super(false);
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.ksession = this.createKSession(EVENT_BASED_GATEWAY);
    }

    @Test(timeout=30000L)
    public void testConditional() {
        TrackingProcessEventListener tpel = new TrackingProcessEventListener();
        this.ksession.addEventListener((ProcessEventListener)tpel);
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(CommandFactory.newInsert((Object)5));
        commands.add(CommandFactory.newStartProcess((String)EVENT_BASED_GATEWAY_ID));
        this.ksession.execute((Command)CommandFactory.newBatchExecution(commands));
        TrackingListenerAssert.assertProcessStarted((TrackingProcessEventListener)tpel, (String)EVENT_BASED_GATEWAY_ID);
        TrackingListenerAssert.assertTriggeredAndLeft((TrackingProcessEventListener)tpel, (String)"start");
        TrackingListenerAssert.assertTriggeredAndLeft((TrackingProcessEventListener)tpel, (String)"fork");
        TrackingListenerAssert.assertTriggeredAndLeft((TrackingProcessEventListener)tpel, (String)"cond");
        TrackingListenerAssert.assertTriggeredAndLeft((TrackingProcessEventListener)tpel, (String)"join");
        TrackingListenerAssert.assertTriggered((TrackingProcessEventListener)tpel, (String)"end");
        TrackingListenerAssert.assertProcessCompleted((TrackingProcessEventListener)tpel, (String)EVENT_BASED_GATEWAY_ID);
    }

    @Test(timeout=30000L)
    public void testSignal() {
        TrackingProcessEventListener tpel = new TrackingProcessEventListener();
        this.ksession.addEventListener((ProcessEventListener)tpel);
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(CommandFactory.newStartProcess((String)EVENT_BASED_GATEWAY_ID));
        commands.add(CommandFactory.newSignalEvent((String)"sigkill", null));
        this.ksession.execute((Command)CommandFactory.newBatchExecution(commands));
        TrackingListenerAssert.assertProcessStarted((TrackingProcessEventListener)tpel, (String)EVENT_BASED_GATEWAY_ID);
        TrackingListenerAssert.assertTriggeredAndLeft((TrackingProcessEventListener)tpel, (String)"start");
        TrackingListenerAssert.assertTriggeredAndLeft((TrackingProcessEventListener)tpel, (String)"fork");
        TrackingListenerAssert.assertTriggeredAndLeft((TrackingProcessEventListener)tpel, (String)"sig");
        TrackingListenerAssert.assertTriggeredAndLeft((TrackingProcessEventListener)tpel, (String)"join");
        TrackingListenerAssert.assertTriggered((TrackingProcessEventListener)tpel, (String)"end");
        TrackingListenerAssert.assertProcessCompleted((TrackingProcessEventListener)tpel, (String)EVENT_BASED_GATEWAY_ID);
    }

    @Test(timeout=30000L)
    public void testMessage() {
        TrackingProcessEventListener tpel = new TrackingProcessEventListener();
        this.ksession.addEventListener((ProcessEventListener)tpel);
        ProcessInstance pi = (ProcessInstance)this.ksession.execute(CommandFactory.newStartProcess((String)EVENT_BASED_GATEWAY_ID));
        TrackingListenerAssert.assertProcessStarted((TrackingProcessEventListener)tpel, (String)EVENT_BASED_GATEWAY_ID);
        TrackingListenerAssert.assertTriggeredAndLeft((TrackingProcessEventListener)tpel, (String)"start");
        TrackingListenerAssert.assertTriggeredAndLeft((TrackingProcessEventListener)tpel, (String)"fork");
        TrackingListenerAssert.assertTriggered((TrackingProcessEventListener)tpel, (String)"msg");
        this.ksession.execute(CommandFactory.newSignalEvent((long)pi.getId(), (String)"Message-message1", null));
        TrackingListenerAssert.assertLeft((TrackingProcessEventListener)tpel, (String)"msg");
        TrackingListenerAssert.assertTriggeredAndLeft((TrackingProcessEventListener)tpel, (String)"join");
        TrackingListenerAssert.assertTriggered((TrackingProcessEventListener)tpel, (String)"end");
        TrackingListenerAssert.assertProcessCompleted((TrackingProcessEventListener)tpel, (String)EVENT_BASED_GATEWAY_ID);
    }

    @Test(timeout=30000L)
    public void testTimer() throws InterruptedException {
        Assume.assumeFalse((boolean)(this.ksession.getSessionClock() instanceof SessionPseudoClock));
        TrackingProcessEventListener tpel = new TrackingProcessEventListener();
        this.ksession.addEventListener((ProcessEventListener)tpel);
        this.ksession.execute(CommandFactory.newStartProcess((String)EVENT_BASED_GATEWAY_ID));
        TrackingListenerAssert.assertProcessStarted((TrackingProcessEventListener)tpel, (String)EVENT_BASED_GATEWAY_ID);
        TrackingListenerAssert.assertTriggeredAndLeft((TrackingProcessEventListener)tpel, (String)"start");
        TrackingListenerAssert.assertTriggered((TrackingProcessEventListener)tpel, (String)"fork");
        TrackingListenerAssert.assertLeft((TrackingProcessEventListener)tpel, (String)"fork", (int)4);
        TrackingListenerAssert.assertTriggered((TrackingProcessEventListener)tpel, (String)"cond");
        TrackingListenerAssert.assertTriggered((TrackingProcessEventListener)tpel, (String)"msg");
        TrackingListenerAssert.assertTriggered((TrackingProcessEventListener)tpel, (String)"sig");
        TrackingListenerAssert.assertTriggered((TrackingProcessEventListener)tpel, (String)"timer");
        Thread.sleep(1500L);
        TrackingListenerAssert.assertLeft((TrackingProcessEventListener)tpel, (String)"timer");
        TrackingListenerAssert.assertTriggeredAndLeft((TrackingProcessEventListener)tpel, (String)"join");
        TrackingListenerAssert.assertTriggered((TrackingProcessEventListener)tpel, (String)"end");
        TrackingListenerAssert.assertProcessCompleted((TrackingProcessEventListener)tpel, (String)EVENT_BASED_GATEWAY_ID);
    }
}

