/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.jobexec;

import java.util.HashMap;
import java.util.List;
import org.jbpm.executor.impl.wih.AsyncWorkItemHandler;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.process.audit.VariableInstanceLog;
import org.jbpm.test.JbpmAsyncJobTestCase;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;

public class AsyncTaskCallbackTest
extends JbpmAsyncJobTestCase {
    public static final String ASYNC_EXECUTOR_CALLBACK = "org/jbpm/test/functional/jobexec/AsyncExecutorCallback.bpmn2";
    public static final String ASYNC_EXECUTOR_CALLBACK_ID = "org.jbpm.test.functional.jobexec.AsyncExecutorCallback";
    public static final String ASYNC_DATA_EXECUTOR = "org/jbpm/test/functional/jobexec/AsyncDataExecutor.bpmn2";
    public static final String ASYNC_DATA_EXECUTOR_ID = "org.jbpm.test.functional.jobexec.AsyncDataExecutor";
    public static final String CALLBACK_COMMAND = "org.jbpm.test.jobexec.UserCommandWithCallback";
    private JPAAuditLogService auditLogService;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.auditLogService = new JPAAuditLogService(this.getEmf());
        this.auditLogService.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown() throws Exception {
        try {
            this.auditLogService.clear();
            this.auditLogService.dispose();
        }
        finally {
            super.tearDown();
        }
    }

    @Test
    public void testTaskCallback() throws Exception {
        KieSession ksession = this.createKSession(ASYNC_EXECUTOR_CALLBACK, ASYNC_DATA_EXECUTOR);
        WorkItemManager wim = ksession.getWorkItemManager();
        wim.registerWorkItemHandler("async", (WorkItemHandler)new AsyncWorkItemHandler(this.getExecutorService()));
        HashMap<String, String> pm = new HashMap<String, String>();
        pm.put("_command", CALLBACK_COMMAND);
        ProcessInstance pi = ksession.startProcess(ASYNC_EXECUTOR_CALLBACK_ID, pm);
        Thread.sleep(5000L);
        this.assertNodeTriggered(pi.getId(), new String[]{"Process async", "Continue"});
        this.assertProcessInstanceCompleted(pi.getId());
        List varLogList = this.auditLogService.findVariableInstances(pi.getId(), "_user");
        AsyncTaskCallbackTest.assertEquals((long)1L, (long)varLogList.size());
        VariableInstanceLog userVarLog = (VariableInstanceLog)varLogList.get(0);
        AsyncTaskCallbackTest.assertEquals((Object)"[Name=john after command execution, age=25]", (Object)userVarLog.getValue());
    }
}

