/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.jobexec;

import java.util.HashMap;
import java.util.List;
import javax.naming.InitialContext;
import javax.transaction.UserTransaction;
import org.assertj.core.api.Assertions;
import org.jbpm.executor.impl.wih.AsyncWorkItemHandler;
import org.jbpm.test.JbpmAsyncJobTestCase;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.api.runtime.query.QueryContext;

public class AsyncTaskTransactionTest
extends JbpmAsyncJobTestCase {
    public static final String ASYNC_DATA_EXECUTOR = "org/jbpm/test/functional/jobexec/AsyncDataExecutor.bpmn2";
    public static final String ASYNC_DATA_EXECUTOR_ID = "org.jbpm.test.functional.jobexec.AsyncDataExecutor";
    public static final String ASYNC_EXECUTOR_2 = "org/jbpm/test/functional/jobexec/AsyncExecutor2.bpmn2";
    public static final String ASYNC_EXECUTOR_2_ID = "org.jbpm.test.functional.jobexec.AsyncExecutor2";
    public static final String USER_COMMAND = "org.jbpm.test.jobexec.UserCommand";
    public static final String USER_FAILING_COMMAND = "org.jbpm.test.jobexec.UserFailingCommand";

    @Test
    public void testJobCommitInAsyncExec() throws Exception {
        KieSession ksession = this.registerAsyncHandler(this.createKSession(ASYNC_EXECUTOR_2, ASYNC_DATA_EXECUTOR));
        UserTransaction ut = this.getUserTransaction();
        ut.begin();
        HashMap<String, String> pm = new HashMap<String, String>();
        pm.put("_command", USER_COMMAND);
        ProcessInstance pi = ksession.startProcess(ASYNC_EXECUTOR_2_ID, pm);
        ut.commit();
        this.assertProcessInstanceCompleted(pi.getId());
        Thread.sleep(4000L);
        Assertions.assertThat((List)this.getExecutorService().getCompletedRequests(new QueryContext())).hasSize(1);
    }

    @Test
    public void testJobRollbackInAsyncExec() throws Exception {
        KieSession ksession = this.registerAsyncHandler(this.createKSession(ASYNC_EXECUTOR_2, ASYNC_DATA_EXECUTOR));
        UserTransaction ut = this.getUserTransaction();
        ut.begin();
        HashMap<String, String> pm = new HashMap<String, String>();
        pm.put("_command", USER_COMMAND);
        ProcessInstance pi = ksession.startProcess(ASYNC_EXECUTOR_2_ID, pm);
        this.assertProcessInstanceCompleted(pi.getId());
        ut.rollback();
        this.assertProcessInstanceNeverRun(pi.getId());
        Assertions.assertThat((List)this.getExecutorService().getCompletedRequests(new QueryContext())).hasSize(0);
    }

    @Test
    public void testJobCommit() throws Exception {
        KieSession ksession = this.registerAsyncHandler(this.createKSession(ASYNC_DATA_EXECUTOR));
        UserTransaction ut = this.getUserTransaction();
        ut.begin();
        HashMap<String, String> pm = new HashMap<String, String>();
        pm.put("command", USER_COMMAND);
        ProcessInstance pi = ksession.startProcess(ASYNC_DATA_EXECUTOR_ID, pm);
        ut.commit();
        Thread.sleep(4000L);
        this.assertProcessInstanceCompleted(pi.getId());
    }

    @Test
    public void testJobRollback() throws Exception {
        KieSession ksession = this.registerAsyncHandler(this.createKSession(ASYNC_DATA_EXECUTOR));
        UserTransaction ut = this.getUserTransaction();
        ut.begin();
        HashMap<String, String> pm = new HashMap<String, String>();
        pm.put("_command", USER_FAILING_COMMAND);
        ProcessInstance pi = ksession.startProcess(ASYNC_DATA_EXECUTOR_ID, pm);
        ut.rollback();
        this.assertProcessInstanceNeverRun(pi.getId());
    }

    private UserTransaction getUserTransaction() throws Exception {
        return (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
    }

    private KieSession registerAsyncHandler(KieSession ksession) {
        WorkItemManager wim = ksession.getWorkItemManager();
        wim.registerWorkItemHandler("async", (WorkItemHandler)new AsyncWorkItemHandler(this.getExecutorService()));
        return ksession;
    }
}

