/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.log;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.test.JbpmTestCase;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.audit.NodeInstanceLog;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.runtime.manager.audit.query.NodeInstanceLogDeleteBuilder;

public class NodeInstanceLogCleanTest
extends JbpmTestCase {
    private static final String HELLO_WORLD_PROCESS = "org/jbpm/test/functional/common/HelloWorldProcess1.bpmn";
    private static final String HELLO_WORLD_PROCESS_ID = "org.jbpm.test.functional.common.HelloWorldProcess1";
    private static final String HUMAN_TASK_LOCALE = "org/jbpm/test/functional/log/NodeInstanceLogClean-humanTaskLocale.bpmn2";
    private static final String HUMAN_TASK_LOCALE_ID = "org.jbpm.test.functional.log.NodeInstanceLogClean-humanTaskLocale";
    private JPAAuditLogService auditService;

    public void setUp() throws Exception {
        super.setUp();
        this.auditService = new JPAAuditLogService(this.getEmf());
        this.auditService.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDown() throws Exception {
        try {
            this.auditService.clear();
            this.auditService.dispose();
        }
        finally {
            super.tearDown();
        }
    }

    @Test
    public void deleteLogsByNodeNameAndInstanceId() {
        KieSession kieSession = this.createKSession(HELLO_WORLD_PROCESS);
        List<ProcessInstance> instanceList = this.startProcess(kieSession, HELLO_WORLD_PROCESS_ID, 2);
        int resultCount = ((NodeInstanceLogDeleteBuilder)this.auditService.nodeInstanceLogDelete().nodeName(new String[]{"Hello world"}).processInstanceId(new long[]{instanceList.get(0).getId()})).build().execute();
        Assertions.assertThat((int)resultCount).isEqualTo(2);
        List nodeList = this.auditService.nodeInstanceLogQuery().nodeName(new String[]{"Start", "End", "Hello world"}).build().getResultList();
        ((AbstractListAssert)Assertions.assertThat((List)nodeList).hasSize(10)).extracting("nodeName").containsOnly(new Object[]{"Start", "End", "Hello world"});
    }

    @Test
    public void deleteLogsByNodeId() {
        KieSession kieSession = this.createKSession(HELLO_WORLD_PROCESS);
        this.startProcess(kieSession, HELLO_WORLD_PROCESS_ID, 2);
        int resultCount = this.auditService.nodeInstanceLogDelete().nodeId(new String[]{"_3"}).build().execute();
        Assertions.assertThat((int)resultCount).isEqualTo(4);
        List nodeList = this.auditService.nodeInstanceLogQuery().nodeId(new String[]{"_1", "_2", "_3"}).build().getResultList();
        ((AbstractListAssert)Assertions.assertThat((List)nodeList).hasSize(8)).extracting("nodeName").containsOnly(new Object[]{"Start", "Hello world"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void deleteLogsByNodeInstanceId() {
        KieSession kieSession = null;
        List<ProcessInstance> processInstanceList = null;
        try {
            kieSession = this.createKSession(HUMAN_TASK_LOCALE);
            processInstanceList = this.startProcess(kieSession, HUMAN_TASK_LOCALE_ID, 1);
            List nodeInstanceList = this.auditService.nodeInstanceLogQuery().nodeName(new String[]{"\u7a7a\u624b"}).build().getResultList();
            Assertions.assertThat((List)nodeInstanceList).hasSize(1);
            int resultCount = this.auditService.nodeInstanceLogDelete().nodeInstanceId(new String[]{((NodeInstanceLog)nodeInstanceList.get(0)).getNodeId()}).build().execute();
            Assertions.assertThat((int)resultCount).isEqualTo(0);
            if (processInstanceList != null) {
                this.abortProcess(kieSession, processInstanceList);
            }
            if (kieSession == null) return;
        }
        catch (Throwable throwable) {
            if (processInstanceList != null) {
                this.abortProcess(kieSession, processInstanceList);
            }
            if (kieSession == null) throw throwable;
            kieSession.dispose();
            throw throwable;
        }
        kieSession.dispose();
    }

    private void abortProcess(KieSession kieSession, List<ProcessInstance> processInstanceList) {
        for (ProcessInstance processInstance : processInstanceList) {
            this.abortProcess(kieSession, processInstance.getId());
        }
    }

    private void abortProcess(KieSession kieSession, long pid) {
        ProcessInstance processInstance = kieSession.getProcessInstance(pid);
        if (processInstance != null && processInstance.getState() == 1) {
            kieSession.abortProcessInstance(pid);
        }
    }

    private List<ProcessInstance> startProcess(KieSession kieSession, String processId, int count) {
        ArrayList<ProcessInstance> piList = new ArrayList<ProcessInstance>();
        for (int i = 0; i < count; ++i) {
            ProcessInstance pi = kieSession.startProcess(processId);
            if (pi == null) continue;
            piList.add(pi);
        }
        return piList;
    }
}

