/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.regression;

import java.util.ArrayList;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.listener.TrackingAgendaEventListener;
import org.jbpm.test.listener.TrackingProcessEventListener;
import org.jbpm.test.listener.TrackingRuleRuntimeEventListener;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import qa.tools.ikeeper.annotation.BZ;

public class RuleTest
extends JbpmTestCase {
    private static final String ON_ENTRY_EVENT = "org/jbpm/test/regression/Rule-onEntryEvent.bpmn2";
    private static final String ON_ENTRY_EVENT_ID = "org.jbpm.test.regression.BusinessCalendar-timer";
    private static final String ON_ENTRY_EVENT_DRL = "org/jbpm/test/regression/Rule-onEntryEvent.drl";

    @Test
    @BZ(value={"852095"})
    public void testNoOnEntryEvent() {
        HashMap<String, ResourceType> res = new HashMap<String, ResourceType>();
        res.put(ON_ENTRY_EVENT, ResourceType.BPMN2);
        res.put(ON_ENTRY_EVENT_DRL, ResourceType.DRL);
        KieSession ksession = this.createKSession(res);
        ArrayList<Command> commands = new ArrayList<Command>();
        TrackingAgendaEventListener agendaEvents = new TrackingAgendaEventListener();
        TrackingProcessEventListener processEvents = new TrackingProcessEventListener();
        TrackingRuleRuntimeEventListener ruleEvents = new TrackingRuleRuntimeEventListener();
        ksession.addEventListener((AgendaEventListener)agendaEvents);
        ksession.addEventListener((ProcessEventListener)processEvents);
        ksession.addEventListener((RuleRuntimeEventListener)ruleEvents);
        commands.add(RuleTest.getCommands().newStartProcess(ON_ENTRY_EVENT_ID));
        commands.add(RuleTest.getCommands().newFireAllRules());
        ksession.execute((Command)RuleTest.getCommands().newBatchExecution(commands, null));
        Assertions.assertThat((boolean)processEvents.wasProcessStarted(ON_ENTRY_EVENT_ID)).isTrue();
        Assertions.assertThat((boolean)processEvents.wasNodeTriggered("Rule")).isTrue();
        Assertions.assertThat((boolean)ruleEvents.wasInserted((Object)"OnEntry")).isTrue();
        Assertions.assertThat((boolean)agendaEvents.isRuleFired("dummyRule")).isTrue();
        Assertions.assertThat((boolean)ruleEvents.wasInserted((Object)"OnExit")).isTrue();
        Assertions.assertThat((boolean)processEvents.wasNodeLeft("Rule")).isTrue();
        Assertions.assertThat((boolean)processEvents.wasProcessCompleted(ON_ENTRY_EVENT_ID)).isTrue();
    }
}

