/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.regression.subprocess;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.jbpm.test.JbpmJUnitBaseTestCase;
import org.jbpm.test.JbpmTestCase;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.audit.AuditService;
import org.kie.api.runtime.manager.audit.ProcessInstanceLog;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import qa.tools.ikeeper.annotation.BZ;

public class ReusableSubprocessTest
extends JbpmTestCase {
    private static final String WAIT_FOR_COMPLETION_FALSE_PARENT = "org/jbpm/test/regression/subprocess/ReusableSubprocess-waitForCompletionFalse-parent.bpmn2";
    private static final String WAIT_FOR_COMPLETION_FALSE_PARENT_ID = "org.jbpm.test.regression.subprocess.ReusableSubprocess-waitForCompletionFalse-parent";
    private static final String WAIT_FOR_COMPLETION_FALSE_SUBPROCESS = "org/jbpm/test/regression/subprocess/ReusableSubprocess-waitForCompletionFalse-subprocess.bpmn2";
    private static final String DEPENDENT_SUBPROCESS_ABORT_PARENT = "org/jbpm/test/regression/subprocess/ReusableSubprocess-dependentSubprocessAbort-parent.bpmn2";
    private static final String DEPENDENT_SUBPROCESS_ABORT_PARENT_ID = "org.jbpm.test.regression.subprocess.ReusableSubprocess-dependentSubprocessAbort-parent";
    private static final String DEPENDENT_SUBPROCESS_ABORT_SUBPROCESS = "org/jbpm/test/regression/subprocess/ReusableSubprocess-dependentSubprocessAbort-subprocess.bpmn2";
    private static final String DEPENDENT_SUBPROCESS_ABORT_SUBPROCESS_ID = "org.jbpm.test.regression.subprocess.ReusableSubprocess-dependentSubprocessAbort-subprocess";

    @Test
    @BZ(value={"1194180"})
    public void testWaitForCompletionFalse() throws Exception {
        this.createRuntimeManager(JbpmJUnitBaseTestCase.Strategy.PROCESS_INSTANCE, "BZ1194180-ppi-manager", new String[]{WAIT_FOR_COMPLETION_FALSE_PARENT, WAIT_FOR_COMPLETION_FALSE_SUBPROCESS});
        KieSession ksession = this.getRuntimeEngine().getKieSession();
        Assertions.assertThat((Object)ksession).isNotNull();
        ksession.startProcess(WAIT_FOR_COMPLETION_FALSE_PARENT_ID);
        Thread.sleep(3000L);
    }

    @Test
    @BZ(value={"1128597"})
    public void testDependentSubprocessAbort() {
        RuntimeManager manager = this.createRuntimeManager(JbpmJUnitBaseTestCase.Strategy.PROCESS_INSTANCE, "myPpiManager", new String[]{DEPENDENT_SUBPROCESS_ABORT_PARENT, DEPENDENT_SUBPROCESS_ABORT_SUBPROCESS});
        Assertions.assertThat((Object)manager).isNotNull();
        RuntimeEngine runtime = this.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        Assertions.assertThat((Object)ksession).isNotNull();
        Assertions.assertThat((int)ksession.getId()).isEqualTo(2);
        ProcessInstance pi1 = ksession.startProcess(DEPENDENT_SUBPROCESS_ABORT_PARENT_ID);
        this.assertProcessInstanceActive(pi1.getId());
        ksession.abortProcessInstance(pi1.getId());
        AuditService logService = this.getLogService();
        List logs = logService.findActiveProcessInstances(DEPENDENT_SUBPROCESS_ABORT_PARENT_ID);
        Assertions.assertThat((List)logs).isNotNull();
        Assertions.assertThat((List)logs).hasSize(0);
        logs = logService.findActiveProcessInstances(DEPENDENT_SUBPROCESS_ABORT_SUBPROCESS_ID);
        Assertions.assertThat((List)logs).isNotNull();
        Assertions.assertThat((List)logs).hasSize(0);
        logs = logService.findProcessInstances(DEPENDENT_SUBPROCESS_ABORT_PARENT_ID);
        Assertions.assertThat((List)logs).isNotNull();
        Assertions.assertThat((List)logs).hasSize(1);
        this.assertProcessInstanceAborted(((ProcessInstanceLog)logs.get(0)).getProcessInstanceId());
        logs = logService.findProcessInstances(DEPENDENT_SUBPROCESS_ABORT_SUBPROCESS_ID);
        Assertions.assertThat((List)logs).isNotNull();
        Assertions.assertThat((List)logs).hasSize(1);
        this.assertProcessInstanceAborted(((ProcessInstanceLog)logs.get(0)).getProcessInstanceId());
        manager.close();
    }
}

