/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.regression.task;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.jbpm.test.JbpmTestCase;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import qa.tools.ikeeper.annotation.BZ;

public class HumanTaskSwimlaneTest
extends JbpmTestCase {
    private static final String SWIMLANE_SAME_GROUPS = "org/jbpm/test/regression/task/HumanTaskSwimlane-sameGroups.bpmn2";
    private static final String SWIMLANE_SAME_GROUPS_ID = "org.jbpm.test.regression.task.HumanTaskSwimlane-sameGroups";
    private static final String SWIMLANE_DIFFERENT_GROUPS = "org/jbpm/test/regression/task/HumanTaskSwimlane-differentGroups.bpmn2";
    private static final String SWIMLANE_DIFFERENT_GROUPS_ID = "org.jbpm.test.regression.task.HumanTaskSwimlane-differentGroups";
    private TaskService taskService;

    @Test
    @BZ(value={"997139"})
    public void testSameGroups() {
        this.createRuntimeManager(new String[]{SWIMLANE_SAME_GROUPS});
        KieSession ksession = this.getRuntimeEngine().getKieSession();
        this.taskService = this.getRuntimeEngine().getTaskService();
        ProcessInstance pi = ksession.startProcess(SWIMLANE_SAME_GROUPS_ID);
        long task1 = this.getActiveTask(pi).getId();
        this.taskService.claim(task1, "john");
        this.taskService.start(task1, "john");
        this.taskService.complete(task1, "john", null);
        Task task2 = this.getActiveTask(pi);
        Assertions.assertThat((Comparable)task2.getTaskData().getStatus()).isEqualTo((Object)Status.Reserved);
        Assertions.assertThat((String)task2.getTaskData().getActualOwner().getId()).isEqualTo((Object)"john");
        Assertions.assertThat((String)((OrganizationalEntity)task2.getPeopleAssignments().getPotentialOwners().get(0)).getId()).isEqualTo((Object)"users");
    }

    @Test
    @BZ(value={"997139"})
    public void testDifferentGroups() {
        this.createRuntimeManager(new String[]{SWIMLANE_DIFFERENT_GROUPS});
        KieSession ksession = this.getRuntimeEngine().getKieSession();
        this.taskService = this.getRuntimeEngine().getTaskService();
        ProcessInstance pi = ksession.startProcess(SWIMLANE_DIFFERENT_GROUPS_ID);
        long task1 = this.getActiveTask(pi).getId();
        this.taskService.claim(task1, "john");
        this.taskService.start(task1, "john");
        this.taskService.complete(task1, "john", null);
        Task task2 = this.getActiveTask(pi);
        Assertions.assertThat((Comparable)task2.getTaskData().getStatus()).isEqualTo((Object)Status.Ready);
        Assertions.assertThat((Object)task2.getTaskData().getActualOwner()).isNull();
        Assertions.assertThat((String)((OrganizationalEntity)task2.getPeopleAssignments().getPotentialOwners().get(0)).getId()).isEqualTo((Object)"sales");
    }

    private Task getActiveTask(ProcessInstance pi) {
        List taskIds = this.taskService.getTasksByProcessInstanceId(pi.getId());
        for (Long taskId : taskIds) {
            Task task = this.taskService.getTaskById(taskId.longValue());
            if (task.getTaskData().getStatus().equals((Object)Status.Completed)) continue;
            return task;
        }
        return null;
    }
}

