/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.entity;

import java.io.Serializable;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.jbpm.test.entity.Patient;
import org.jbpm.test.entity.RecordRow;

@Entity
public class MedicalRecord
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Long id;
    private String description;
    @OneToOne(optional=false, cascade={CascadeType.ALL})
    @JoinColumn(name="PATIENT_ID", unique=true)
    private Patient patient;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="medicalRecord")
    private List<RecordRow> rows;
    private int priority;

    public MedicalRecord() {
    }

    public MedicalRecord(String desc, Patient patient) {
        this.description = desc;
        this.patient = patient;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Patient getPatient() {
        return this.patient;
    }

    public void setPatient(Patient patient) {
        this.patient = patient;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public List<RecordRow> getRows() {
        return this.rows;
    }

    public void setRows(List<RecordRow> rows) {
        this.rows = rows;
    }

    public String toString() {
        return "MedicalRecord{id=" + this.id + ", desc=" + this.description + ", patient=" + this.patient.getId() + ", rows=" + this.rows + ", priority=" + this.priority + '}';
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MedicalRecord other = (MedicalRecord)obj;
        if (!(this.id == other.id || this.id != null && this.id.equals(other.id))) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (!(this.patient == other.patient || this.patient != null && this.patient.equals(other.patient))) {
            return false;
        }
        if (!(this.rows == other.rows || this.rows != null && this.rows.equals(other.rows))) {
            return false;
        }
        return this.priority == other.priority;
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + (this.id != null ? this.id.hashCode() : 0);
        hash = 67 * hash + (this.description != null ? this.description.hashCode() : 0);
        hash = 67 * hash + (this.patient != null ? this.patient.hashCode() : 0);
        hash = 67 * hash + (this.rows != null ? this.rows.hashCode() : 0);
        hash = 67 * hash + this.priority;
        return hash;
    }
}

