/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.event;

import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.drools.core.command.runtime.process.RegisterWorkItemHandlerCommand;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.listener.IterableProcessEventListener;
import org.jbpm.test.listener.TrackingProcessEventListener;
import org.jbpm.test.tools.IterableListenerAssert;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.internal.command.CommandFactory;
import qa.tools.ikeeper.annotation.BZ;

public class EndEventTest
extends JbpmTestCase {
    private static final String COMPENSATE = "org/jbpm/test/functional/event/EndEvent-compensate.bpmn2";
    private static final String COMPENSATE_ID = "org.jbpm.test.functional.event.EndEvent-compensate";
    private static final String ERROR = "org/jbpm/test/functional/event/EndEvent-error.bpmn2";
    private static final String ERROR_ID = "org.jbpm.test.functional.event.EndEvent-error";
    private static final String ESCALATION = "org/jbpm/test/functional/event/EndEvent-escalation.bpmn2";
    private static final String ESCALATION_ID = "org.jbpm.test.functional.event.EndEvent-escalation";
    private static final String MESSAGE = "org/jbpm/test/functional/event/EndEvent-message.bpmn2";
    private static final String MESSAGE_ID = "org.jbpm.test.functional.event.EndEvent-message";
    private static final String NONE = "org/jbpm/test/functional/event/EndEvent-none.bpmn2";
    private static final String NONE_ID = "org.jbpm.test.functional.event.EndEvent-none";
    private static final String TERMINATING = "org/jbpm/test/functional/event/EndEvent-terminating.bpmn2";
    private static final String TERMINATING_ID = "org.jbpm.test.functional.event.EndEvent-terminating";

    public EndEventTest() {
        super(false);
    }

    @BZ(value={"1021631"})
    @Test(timeout=30000L)
    public void testCompensateEndEvent() {
        KieSession ksession = this.createKSession(COMPENSATE);
        IterableProcessEventListener events = new IterableProcessEventListener();
        TrackingProcessEventListener process = new TrackingProcessEventListener();
        ksession.addEventListener((ProcessEventListener)events);
        ksession.addEventListener((ProcessEventListener)process);
        Command cmd = EndEventTest.getCommands().newStartProcess(COMPENSATE_ID);
        ProcessInstance pi = (ProcessInstance)ksession.execute(cmd);
        Assertions.assertThat((boolean)process.wasProcessStarted(COMPENSATE_ID)).isTrue();
        Assertions.assertThat((boolean)process.wasProcessCompleted(COMPENSATE_ID)).isTrue();
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)events, (String)COMPENSATE_ID);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)events, (String)"start");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)events, (String)"subprocess");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)events, (String)"sub-start");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)events, (String)"script");
        IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)events, (String)"x", null, (Object)0);
        IterableListenerAssert.assertLeft((IterableProcessEventListener)events, (String)"script");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)events, (String)"sub-end");
        IterableListenerAssert.assertLeft((IterableProcessEventListener)events, (String)"subprocess");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)events, (String)"end");
        IterableListenerAssert.assertLeft((IterableProcessEventListener)events, (String)"compensate-catch");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)events, (String)"compensate");
        IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)events, (String)"x", (Object)0, null);
        IterableListenerAssert.assertLeft((IterableProcessEventListener)events, (String)"compensate");
        Assertions.assertThat((int)pi.getState()).isEqualTo(2);
    }

    @Test(timeout=30000L)
    public void testErrorEndEvent() {
        KieSession ksession = this.createKSession(ERROR);
        IterableProcessEventListener events = new IterableProcessEventListener();
        TrackingProcessEventListener process = new TrackingProcessEventListener();
        ksession.addEventListener((ProcessEventListener)events);
        ksession.addEventListener((ProcessEventListener)process);
        Command cmd = EndEventTest.getCommands().newStartProcess(ERROR_ID);
        ksession.execute(cmd);
        Assertions.assertThat((boolean)process.wasProcessStarted(ERROR_ID)).isTrue();
        Assertions.assertThat((boolean)process.wasProcessCompleted(ERROR_ID)).isFalse();
        Assertions.assertThat((boolean)process.wasProcessAborted(ERROR_ID)).isTrue();
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)events, (String)ERROR_ID);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)events, (String)"start");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)events, (String)"script");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)events, (String)"end");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)events, (String)ERROR_ID);
        Assertions.assertThat((boolean)events.hasNext()).isFalse();
    }

    @BZ(value={"1015221"})
    @Test(timeout=30000L)
    public void testEscalationEndEvent() {
        KieSession ksession = this.createKSession(ESCALATION);
        IterableProcessEventListener events = new IterableProcessEventListener();
        TrackingProcessEventListener process = new TrackingProcessEventListener();
        ksession.addEventListener((ProcessEventListener)events);
        ksession.addEventListener((ProcessEventListener)process);
        Command cmd = EndEventTest.getCommands().newStartProcess(ESCALATION_ID);
        ksession.execute(cmd);
        Assertions.assertThat((boolean)process.wasProcessStarted(ESCALATION_ID)).isTrue();
        Assertions.assertThat((boolean)process.wasProcessCompleted(ESCALATION_ID)).isFalse();
        Assertions.assertThat((boolean)process.wasProcessAborted(ESCALATION_ID)).isTrue();
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)events, (String)ESCALATION_ID);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)events, (String)"start");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)events, (String)"script");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)events, (String)"end");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)events, (String)ESCALATION_ID);
        Assert.assertFalse((boolean)events.hasNext());
    }

    @Test(timeout=30000L)
    public void testMessageEndEvent() {
        KieSession ksession = this.createKSession(MESSAGE);
        IterableProcessEventListener events = new IterableProcessEventListener();
        TrackingProcessEventListener process = new TrackingProcessEventListener();
        ksession.addEventListener((ProcessEventListener)events);
        ksession.addEventListener((ProcessEventListener)process);
        RecordingHandler handler = new RecordingHandler();
        ArrayList<Object> cmds = new ArrayList<Object>();
        cmds.add(new RegisterWorkItemHandlerCommand("Send Task", (WorkItemHandler)handler));
        cmds.add(EndEventTest.getCommands().newStartProcess(MESSAGE_ID));
        ksession.execute((Command)EndEventTest.getCommands().newBatchExecution(cmds, null));
        Assertions.assertThat((boolean)process.wasProcessStarted(MESSAGE_ID)).isTrue();
        Assertions.assertThat((boolean)process.wasProcessCompleted(MESSAGE_ID)).isTrue();
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)events, (String)MESSAGE_ID);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)events, (String)"start");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)events, (String)"script");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)events, (String)"end");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)events, (String)MESSAGE_ID);
        Assertions.assertThat((boolean)events.hasNext()).isFalse();
        Assertions.assertThat((Object)handler.item).isNotNull();
    }

    @Test(timeout=30000L)
    public void testNoneEndEvent() {
        KieSession ksession = this.createKSession(NONE);
        IterableProcessEventListener events = new IterableProcessEventListener();
        TrackingProcessEventListener process = new TrackingProcessEventListener();
        ksession.addEventListener((ProcessEventListener)events);
        ksession.addEventListener((ProcessEventListener)process);
        Command cmd = CommandFactory.newStartProcess((String)NONE_ID);
        ksession.execute(cmd);
        Assertions.assertThat((boolean)process.wasProcessStarted(NONE_ID)).isTrue();
        Assertions.assertThat((boolean)process.wasProcessCompleted(NONE_ID)).isTrue();
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)events, (String)NONE_ID);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)events, (String)"start");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)events, (String)"script");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)events, (String)"end");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)events, (String)NONE_ID);
        Assertions.assertThat((boolean)events.hasNext()).isFalse();
    }

    @Test(timeout=30000L)
    public void testTerminatingEndEvent() {
        KieSession ksession = this.createKSession(TERMINATING);
        IterableProcessEventListener events = new IterableProcessEventListener();
        TrackingProcessEventListener process = new TrackingProcessEventListener();
        ksession.addEventListener((ProcessEventListener)events);
        ksession.addEventListener((ProcessEventListener)process);
        Command cmd = EndEventTest.getCommands().newStartProcess(TERMINATING_ID);
        ksession.execute(cmd);
        Assertions.assertThat((boolean)process.wasProcessStarted(TERMINATING_ID)).isTrue();
        Assertions.assertThat((boolean)process.wasProcessCompleted(TERMINATING_ID)).isTrue();
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)events, (String)TERMINATING_ID);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)events, (String)"start");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)events, (String)"script");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)events, (String)"end");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)events, (String)TERMINATING_ID);
        Assertions.assertThat((boolean)events.hasNext()).isFalse();
    }

    private static class RecordingHandler
    implements org.drools.core.process.instance.WorkItemHandler {
        private WorkItem item = null;

        private RecordingHandler() {
        }

        public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
            if (this.item != null) {
                throw new IllegalStateException("Work item is already set!");
            }
            this.item = workItem;
        }

        public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        }
    }
}

