/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.regression;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.assertj.core.api.Assertions;
import org.jbpm.process.core.timer.BusinessCalendarImpl;
import org.jbpm.test.JbpmTestCase;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Task;
import qa.tools.ikeeper.annotation.BZ;

@BZ(value={"958384"})
public class BusinessCalendarTest
extends JbpmTestCase {
    private static final String TIMER = "org/jbpm/test/regression/BusinessCalendar-timer.bpmn2";
    private static final String TIMER_ID = "org.jbpm.test.regression.BusinessCalendar-timer";
    private static final String ESCALATION = "org/jbpm/test/regression/BusinessCalendar-escalation.bpmn2";
    private static final String ESCALATION_ID = "org.jbpm.test.regression.BusinessCalendar-escalation";
    private KieSession ksession;
    private TaskService taskService;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.createRuntimeManager(new String[]{TIMER, ESCALATION});
        this.ksession = this.getRuntimeEngine().getKieSession();
        this.taskService = this.getRuntimeEngine().getTaskService();
    }

    @Test
    public void testTimerBusinessHour() throws InterruptedException, ParseException {
        this.configureBusinessCalendar(true);
        long instance = this.ksession.startProcess(TIMER_ID).getId();
        Thread.sleep(2000L);
        this.assertProcessInstanceCompleted(instance);
    }

    @Test
    public void testTimerNonBusinessHour() throws InterruptedException, ParseException {
        this.configureBusinessCalendar(false);
        long instance = this.ksession.startProcess(TIMER_ID).getId();
        Thread.sleep(2000L);
        this.assertProcessInstanceActive(instance);
        this.ksession.abortProcessInstance(instance);
    }

    @Test
    public void testHumanTaskEscalationBusinessHour() throws InterruptedException, ParseException {
        this.configureBusinessCalendar(true);
        long instance = this.ksession.startProcess(ESCALATION_ID).getId();
        long taskId = (Long)this.taskService.getTasksByProcessInstanceId(instance).get(0);
        Thread.sleep(2000L);
        Assertions.assertThat((String)this.getTaskPotentialOwner(taskId)).isEqualToIgnoringCase((CharSequence)"mary");
        this.ksession.abortProcessInstance(instance);
    }

    @Test
    public void testHumanTaskEscalationNonBusinessHour() throws InterruptedException, ParseException {
        this.configureBusinessCalendar(false);
        long instance = this.ksession.startProcess(ESCALATION_ID).getId();
        long taskId = (Long)this.taskService.getTasksByProcessInstanceId(instance).get(0);
        Thread.sleep(2000L);
        Assertions.assertThat((String)this.getTaskPotentialOwner(taskId)).isEqualToIgnoringCase((CharSequence)"john");
        this.ksession.abortProcessInstance(instance);
    }

    private String getTaskPotentialOwner(long taskId) {
        Task task = this.taskService.getTaskById(taskId);
        Assertions.assertThat((Object)task).isNotNull();
        List potentialOwners = task.getPeopleAssignments().getPotentialOwners();
        Assertions.assertThat((List)potentialOwners).isNotEmpty();
        return ((OrganizationalEntity)potentialOwners.get(0)).getId();
    }

    private void configureBusinessCalendar(boolean businessHour) {
        Properties configuration = new Properties();
        if (businessHour) {
            Calendar c = Calendar.getInstance();
            c.add(5, -1);
            int dayOfWeek = c.get(7);
            configuration.setProperty("business.start.hour", "0");
            configuration.setProperty("business.end.hour", "24");
            configuration.setProperty("business.hours.per.day", "24");
            configuration.setProperty("business.days.per.week", "7");
            configuration.setProperty("business.weekend.days", Integer.toString(dayOfWeek));
        } else {
            Date today = new Date();
            Calendar c = Calendar.getInstance();
            c.add(5, 1);
            Date tomorrow = c.getTime();
            String dateFormat = "yyyy-MM-dd";
            SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
            configuration.setProperty("business.holidays", sdf.format(today) + "," + sdf.format(tomorrow));
            configuration.setProperty("business.holiday.date.format", dateFormat);
        }
        BusinessCalendarImpl businessCalendar = new BusinessCalendarImpl(configuration);
        this.ksession.getEnvironment().set("jbpm.business.calendar", (Object)businessCalendar);
    }
}

