/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test;

import java.util.Map;
import java.util.Properties;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.jbpm.test.JbpmJUnitBaseTestCase;
import org.jbpm.test.persistence.util.PersistenceUtil;
import org.junit.Rule;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.kie.api.KieServices;
import org.kie.api.command.KieCommands;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qa.tools.ikeeper.client.BugzillaClient;
import qa.tools.ikeeper.client.ITrackerClient;
import qa.tools.ikeeper.client.JiraClient;
import qa.tools.ikeeper.test.IKeeperJUnitConnector;

public abstract class JbpmTestCase
extends JbpmJUnitBaseTestCase {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected static final String EMPTY_CASE = "EmptyCase.bpmn2";
    @Rule
    public TestRule watcher = new TestWatcher(){

        protected void starting(Description description) {
            System.out.println(" >>> " + description.getMethodName() + " <<< ");
        }

        protected void finished(Description description) {
            System.out.println();
        }
    };
    @Rule
    public IKeeperJUnitConnector issueKeeper = new IKeeperJUnitConnector(new ITrackerClient[]{new BugzillaClient("https://bugzilla.redhat.com"), new JiraClient("https://issues.jboss.org")});

    public JbpmTestCase() {
        this(true);
    }

    public JbpmTestCase(boolean persistence) {
        this(persistence, persistence);
    }

    public JbpmTestCase(boolean setupDataSource, boolean sessionPersistence) {
        this(setupDataSource, sessionPersistence, "org.jbpm.test.persistence");
    }

    public JbpmTestCase(boolean setupDataSource, boolean sessionPersistence, String persistenceUnit) {
        super(setupDataSource, sessionPersistence, persistenceUnit);
    }

    protected Properties getDataSourceProperties() {
        Properties dsProps = PersistenceUtil.getDatasourceProperties();
        dsProps.setProperty("POOL_CONNECTIONS", "false");
        return dsProps;
    }

    public KieSession createKSession(String ... process) {
        this.createRuntimeManager(process);
        return this.getRuntimeEngine().getKieSession();
    }

    public KieSession createKSession(Map<String, ResourceType> res) {
        this.createRuntimeManager(res);
        return this.getRuntimeEngine().getKieSession();
    }

    public KieSession restoreKSession(String ... process) {
        this.disposeRuntimeManager();
        this.createRuntimeManager(process);
        return this.getRuntimeEngine().getKieSession();
    }

    public void assertProcessInstanceNeverRun(long processId) {
        ((ObjectAssert)Assertions.assertThat((Object)this.getLogService().findProcessInstance(processId)).as("Process has been running", new Object[0])).isNull();
    }

    protected static KieServices getServices() {
        return KieServices.Factory.get();
    }

    protected static KieCommands getCommands() {
        return JbpmTestCase.getServices().getCommands();
    }
}

