/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.gateway;

import java.util.HashMap;
import org.drools.core.command.runtime.process.StartProcessCommand;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.listener.IterableProcessEventListener;
import org.jbpm.test.tools.IterableListenerAssert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.runtime.KieSession;

public class InclusiveGatewayTest
extends JbpmTestCase {
    private static final String INCLUSIVE_GATEWAY = "org/jbpm/test/functional/gateway/InclusiveGateway.bpmn";
    private static final String INCLUSIVE_GATEWAY_ID = "org.jbpm.test.functional.gateway.InclusiveGateway";
    private KieSession kieSession;
    private IterableProcessEventListener iterableListener;

    public InclusiveGatewayTest() {
        super(false);
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.kieSession = this.createKSession(INCLUSIVE_GATEWAY);
        this.iterableListener = new IterableProcessEventListener();
    }

    @Test(timeout=30000L)
    public void testInclusive() {
        this.kieSession.addEventListener((ProcessEventListener)this.iterableListener);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 15);
        StartProcessCommand spc = new StartProcessCommand();
        spc.setProcessId(INCLUSIVE_GATEWAY_ID);
        spc.setParameters(params);
        this.kieSession.execute((Command)spc);
        IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)this.iterableListener, (String)"x", null, (Object)15);
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)this.iterableListener, (String)INCLUSIVE_GATEWAY_ID);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)this.iterableListener, (String)"start");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)this.iterableListener, (String)"fork");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)this.iterableListener, (String)"script1");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)this.iterableListener, (String)"join");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)this.iterableListener, (String)"finalScript");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)this.iterableListener, (String)"end");
        IterableListenerAssert.assertLeft((IterableProcessEventListener)this.iterableListener, (String)"fork");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)this.iterableListener, (String)"script2");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)this.iterableListener, (String)"join");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)this.iterableListener, (String)"finalScript");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)this.iterableListener, (String)"end");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)this.iterableListener, (String)INCLUSIVE_GATEWAY_ID);
    }
}

