/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.gateway;

import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.listener.TrackingProcessEventListener;
import org.jbpm.test.tools.TrackingListenerAssert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.runtime.KieSession;

public class ParallelGatewayTest
extends JbpmTestCase {
    private static final String PARALLEL_GATEWAY = "org/jbpm/test/functional/gateway/ParallelGateway.bpmn";
    private static final String PARALLEL_GATEWAY_ID = "org.jbpm.test.functional.gateway.ParallelGateway";
    private KieSession kieSession;
    private TrackingProcessEventListener trackingListener;

    public ParallelGatewayTest() {
        super(false);
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.kieSession = this.createKSession(PARALLEL_GATEWAY);
        this.trackingListener = new TrackingProcessEventListener();
    }

    @Test(timeout=30000L)
    public void testParallel() {
        this.kieSession.addEventListener((ProcessEventListener)this.trackingListener);
        this.kieSession.execute(ParallelGatewayTest.getCommands().newStartProcess(PARALLEL_GATEWAY_ID));
        TrackingListenerAssert.assertProcessStarted((TrackingProcessEventListener)this.trackingListener, (String)PARALLEL_GATEWAY_ID);
        TrackingListenerAssert.assertTriggeredAndLeft((TrackingProcessEventListener)this.trackingListener, (String)"start");
        TrackingListenerAssert.assertTriggered((TrackingProcessEventListener)this.trackingListener, (String)"fork1", (int)1);
        TrackingListenerAssert.assertLeft((TrackingProcessEventListener)this.trackingListener, (String)"fork1", (int)2);
        TrackingListenerAssert.assertTriggeredAndLeft((TrackingProcessEventListener)this.trackingListener, (String)"script1");
        TrackingListenerAssert.assertTriggered((TrackingProcessEventListener)this.trackingListener, (String)"fork2");
        TrackingListenerAssert.assertLeft((TrackingProcessEventListener)this.trackingListener, (String)"fork2", (int)2);
        TrackingListenerAssert.assertTriggeredAndLeft((TrackingProcessEventListener)this.trackingListener, (String)"script2");
        TrackingListenerAssert.assertTriggered((TrackingProcessEventListener)this.trackingListener, (String)"join", (int)3);
        TrackingListenerAssert.assertLeft((TrackingProcessEventListener)this.trackingListener, (String)"join", (int)1);
        TrackingListenerAssert.assertTriggered((TrackingProcessEventListener)this.trackingListener, (String)"end");
        TrackingListenerAssert.assertProcessCompleted((TrackingProcessEventListener)this.trackingListener, (String)PARALLEL_GATEWAY_ID);
    }
}

