/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.subprocess;

import java.util.ArrayList;
import java.util.HashMap;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.listener.DebugProcessEventListener;
import org.jbpm.test.listener.IterableProcessEventListener;
import org.jbpm.test.tools.IterableListenerAssert;
import org.junit.Test;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.runtime.KieSession;
import qa.tools.ikeeper.annotation.BZ;

public class MultipleInstancesSubProcessTest
extends JbpmTestCase {
    private static final String MULTIPLE_INSTANCES = "org/jbpm/test/functional/subprocess/MultipleInstancesSubProcess.bpmn";
    private static final String MULTIPLE_INSTANCES_ID = "org.jbpm.test.functional.subprocess.MultipleInstancesSubProcess";

    public MultipleInstancesSubProcessTest() {
        super(false);
    }

    @BZ(value={"802721"})
    @Test(timeout=30000L)
    public void testMultipleInstances() {
        KieSession kieSession = this.createKSession(MULTIPLE_INSTANCES);
        IterableProcessEventListener eventListener = new IterableProcessEventListener();
        kieSession.addEventListener((ProcessEventListener)eventListener);
        kieSession.addEventListener((ProcessEventListener)new DebugProcessEventListener());
        ArrayList<String> items = new ArrayList<String>();
        items.add("breakfast");
        items.add("lunch");
        items.add("dinner");
        HashMap<String, ArrayList<String>> params = new HashMap<String, ArrayList<String>>();
        params.put("list", items);
        kieSession.execute(MultipleInstancesSubProcessTest.getCommands().newStartProcess(MULTIPLE_INSTANCES_ID, params));
        IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)eventListener, (String)"list", null, items);
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)eventListener, (String)MULTIPLE_INSTANCES_ID);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)eventListener, (String)"start");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)eventListener, (String)"script");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)eventListener, (String)"multipleInstances");
        for (String str : items) {
            IterableListenerAssert.assertChangedMultipleInstancesVariable((IterableProcessEventListener)eventListener, (String)"listItem", null, (Object)str);
        }
        for (String str : items) {
            IterableListenerAssert.assertNextNode((IterableProcessEventListener)eventListener, (String)"innerStart");
            IterableListenerAssert.assertTriggered((IterableProcessEventListener)eventListener, (String)"innerScript");
            IterableListenerAssert.assertChangedMultipleInstancesVariable((IterableProcessEventListener)eventListener, (String)"listItem", (Object)str, (Object)(str + "-eaten"));
            IterableListenerAssert.assertLeft((IterableProcessEventListener)eventListener, (String)"innerScript");
            IterableListenerAssert.assertNextNode((IterableProcessEventListener)eventListener, (String)"innerEnd");
        }
        IterableListenerAssert.assertLeft((IterableProcessEventListener)eventListener, (String)"multipleInstances");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)eventListener, (String)"end");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)eventListener, (String)MULTIPLE_INSTANCES_ID);
    }
}

