/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.regression;

import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import org.assertj.core.api.Assertions;
import org.drools.core.marshalling.impl.ClassObjectMarshallingStrategyAcceptor;
import org.drools.core.marshalling.impl.SerializablePlaceholderResolverStrategy;
import org.drools.persistence.jpa.marshaller.JPAPlaceholderResolverStrategy;
import org.jbpm.test.JbpmJUnitBaseTestCase;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.entity.DocumentVariable;
import org.junit.Test;
import org.kie.api.io.ResourceType;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategyAcceptor;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import qa.tools.ikeeper.annotation.BZ;

public class ProcessInstanceTest
extends JbpmTestCase {
    private static final String EQUALS = "org/jbpm/test/regression/ProcessInstance-equals.bpmn";
    private static final String EQUALS_ID = "org.jbpm.test.regression.ProcessInstance-equals";
    private static final String VARIABLE_PERSISTENCE = "org/jbpm/test/regression/ProcessInstance-variablePersistence.bpmn2";
    private static final String VARIABLE_PERSISTENCE_ID = "org.jbpm.test.regression.ProcessInstance-variablePersistence";

    @Test
    @BZ(value={"949973"})
    public void testProcessEquals() throws Exception {
        KieSession ksession = this.createKSession(EQUALS);
        ProcessInstance pi = ksession.startProcess(EQUALS_ID);
        Assertions.assertThat((boolean)pi.equals(pi)).isTrue();
    }

    @Test
    @BZ(value={"1062346"})
    public void testJPAStrategy() {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.getEmf()).addEnvironmentEntry("org.kie.api.marshalling.ObjectMarshallingStrategies", (Object)new ObjectMarshallingStrategy[]{new JPAPlaceholderResolverStrategy(this.getEmf()), new SerializablePlaceholderResolverStrategy((ObjectMarshallingStrategyAcceptor)ClassObjectMarshallingStrategyAcceptor.DEFAULT)}).addAsset(ResourceFactory.newClassPathResource((String)VARIABLE_PERSISTENCE, ((Object)((Object)this)).getClass()), ResourceType.BPMN2).get();
        this.createRuntimeManager(JbpmJUnitBaseTestCase.Strategy.SINGLETON, new HashMap(), environment, "custom-rm");
        RuntimeEngine engine = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        DocumentVariable dv = new DocumentVariable();
        dv.setContent("empty");
        HashMap<String, DocumentVariable> params = new HashMap<String, DocumentVariable>();
        params.put("document", dv);
        ProcessInstance pi = engine.getKieSession().startProcess(VARIABLE_PERSISTENCE_ID, params);
        EntityManager em = this.getEmf().createEntityManager();
        List documents = em.createQuery("from DocumentVariable").getResultList();
        Assertions.assertThat((List)documents).hasSize(1);
        Assertions.assertThat((String)((DocumentVariable)documents.get(0)).getContent()).isEqualTo("content-changed");
        engine.getKieSession().abortProcessInstance(pi.getId());
    }
}

