/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.jbpm.test.entity.MedicalRecord;

@Entity
public class Patient
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Long id;
    private String name;
    @OneToOne(optional=true, mappedBy="patient")
    private MedicalRecord record;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date nextAppointment;

    public Patient() {
    }

    public Patient(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getNextAppointment() {
        return this.nextAppointment;
    }

    public void setNextAppointment(Date nextAppointment) {
        this.nextAppointment = nextAppointment;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MedicalRecord getRecord() {
        return this.record;
    }

    public void setRecord(MedicalRecord record) {
        this.record = record;
    }

    public String toString() {
        return "Patient{id=" + this.id + ", name=" + this.name + ", record=" + this.record + ", nextAppointment=" + this.nextAppointment + '}';
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Patient other = (Patient)obj;
        if (!(this.id == other.id || this.id != null && this.id.equals(other.id))) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (!(this.record == other.record || this.record != null && this.record.equals(other.record))) {
            return false;
        }
        return this.nextAppointment == other.nextAppointment || this.nextAppointment != null && this.nextAppointment.equals(other.nextAppointment);
    }

    public int hashCode() {
        int hash = 5;
        hash = 47 * hash + (this.id != null ? this.id.hashCode() : 0);
        hash = 47 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 47 * hash + (this.record != null ? this.record.hashCode() : 0);
        hash = 47 * hash + (this.nextAppointment != null ? this.nextAppointment.hashCode() : 0);
        return hash;
    }
}

