/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.task;

import java.util.ArrayList;
import java.util.HashMap;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.domain.Person;
import org.jbpm.test.listener.IterableProcessEventListener;
import org.jbpm.test.tools.IterableListenerAssert;
import org.junit.Test;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.runtime.KieSession;

public class ScriptTaskTest
extends JbpmTestCase {
    private static final String SCRIPT_TASK = "org/jbpm/test/functional/task/ScriptTask.bpmn";
    private static final String SCRIPT_TASK_ID = "org.jbpm.test.functional.task.ScriptTask";

    public ScriptTaskTest() {
        super(false);
    }

    @Test(timeout=30000L)
    public void testScriptTask() {
        KieSession kieSession = this.createKSession(SCRIPT_TASK);
        IterableProcessEventListener ipel = new IterableProcessEventListener();
        kieSession.addEventListener((ProcessEventListener)ipel);
        HashMap<String, Object> params = new HashMap<String, Object>();
        Person p = new Person("Vandrovec");
        params.put("person", p);
        ArrayList<Person> personList = new ArrayList<Person>();
        personList.add(new Person("Birsky"));
        personList.add(new Person("Korcasko"));
        params.put("personList", personList);
        kieSession.execute(ScriptTaskTest.getCommands().newStartProcess(SCRIPT_TASK_ID, params));
        IterableListenerAssert.assertMultipleVariablesChanged((IterableProcessEventListener)ipel, (String[])new String[]{"person", "personList"});
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)ipel, (String)SCRIPT_TASK_ID);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)ipel, (String)"start");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)ipel, (String)"scriptJava");
        IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)ipel, (String)"output", null, (Object)"BirskyKorcaskoVandrovec");
        IterableListenerAssert.assertLeft((IterableProcessEventListener)ipel, (String)"scriptJava");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)ipel, (String)"scriptMvel");
        IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)ipel, (String)"output", (Object)"BirskyKorcaskoVandrovec", (Object)"VandrovecBirskyKorcasko");
        IterableListenerAssert.assertLeft((IterableProcessEventListener)ipel, (String)"scriptMvel");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)ipel, (String)"scriptJavaScript");
        IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)ipel, (String)"output", (Object)"VandrovecBirskyKorcasko", (Object)"JavaScript Node: Vandrovec");
        IterableListenerAssert.assertLeft((IterableProcessEventListener)ipel, (String)"scriptJavaScript");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)ipel, (String)"end");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)ipel, (String)SCRIPT_TASK_ID);
    }
}

