/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.regression.subprocess;

import org.assertj.core.api.Assertions;
import org.jbpm.bpmn2.handler.SignallingTaskHandlerDecorator;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.WorkflowRuntimeException;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import qa.tools.ikeeper.annotation.BZ;

public class EventSubprocessTest
extends JbpmTestCase {
    private static final String ERROR_CODE_EXCEPTION = "org/jbpm/test/regression/subprocess/EventSubprocess-errorCodeException.bpmn2";
    private static final String ERROR_CODE_EXCEPTION_ID = "org.jbpm.test.regression.subprocess.EventSubprocess-errorCodeException";

    @Test
    @BZ(value={"1082111"})
    public void testErrorCodeException() {
        KieSession ksession = this.createKSession(ERROR_CODE_EXCEPTION);
        ksession.getWorkItemManager().registerWorkItemHandler("Request Handler", (WorkItemHandler)new SignallingTaskHandlerDecorator(ExceptionOnPurposeHandler.class, "Error-90277"));
        ksession.getWorkItemManager().registerWorkItemHandler("Error Handler", (WorkItemHandler)new SystemOutWorkItemHandler());
        try {
            ProcessInstance processInstance = ksession.startProcess(ERROR_CODE_EXCEPTION_ID);
            this.assertProcessInstanceNotActive(processInstance.getId(), ksession);
            Assertions.assertThat((String)((WorkflowProcessInstance)processInstance).getOutcome()).isEqualTo("90277");
        }
        catch (WorkflowRuntimeException e) {
            Assert.fail((String)"Error code exceptions in subprocess does not work.");
        }
    }

    public static class ExceptionOnPurposeHandler
    implements WorkItemHandler {
        public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
            throw new RuntimeException("Thrown on purpose");
        }

        public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        }
    }
}

