/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.regression.event;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.iodata.SignalObjectReport;
import org.junit.Test;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.audit.VariableInstanceLog;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkflowProcessInstance;

public class StartEventTest
extends JbpmTestCase {
    private static final String ERROR_EXCEPTION_HANDLER = "org/jbpm/test/regression/event/StartEvent-errorExceptionHandler.bpmn2";
    private static final String ERROR_EXCEPTION_HANDLER_ID = "org.jbpm.test.regression.event.StartEvent-errorExceptionHandler";
    private static final String ERROR_EXCEPTION_MAPPING = "org/jbpm/test/regression/event/StartEvent-errorExceptionMapping.bpmn2";
    private static final String ERROR_EXCEPTION_MAPPING_ID = "org.jbpm.test.regression.event.StartEvent-errorExceptionMapping";
    private static final String SIGNAL_DATA_MAPPING = "org/jbpm/test/regression/event/StartEvent-signalDataMapping.bpmn2";
    private static final String SIGNAL_OUTPUT_TYPE = "org/jbpm/test/regression/event/StartEvent-signalOutputType.bpmn2";

    @Test
    public void testErrorStartEventDefaultExceptionHandler() {
        KieSession ksession = this.createKSession(ERROR_EXCEPTION_HANDLER);
        ProcessInstance pi = ksession.startProcess(ERROR_EXCEPTION_HANDLER_ID);
        List variables = this.getLogService().findVariableInstances(pi.getId(), "capturedException");
        Assertions.assertThat((List)variables).hasSize(2);
        Assertions.assertThat((String)((VariableInstanceLog)variables.get(0)).getValue()).isEqualTo("java.lang.RuntimeException: XXX");
    }

    @Test
    public void testErrorStartEventDataOutputMapping() {
        KieSession ksession = this.createKSession(ERROR_EXCEPTION_MAPPING);
        ProcessInstance pi = ksession.startProcess(ERROR_EXCEPTION_MAPPING_ID);
        List variables = this.getLogService().findVariableInstances(pi.getId(), "capturedException");
        Assertions.assertThat((List)variables).hasSize(2);
        Assertions.assertThat((String)((VariableInstanceLog)variables.get(0)).getValue()).isEqualTo("java.lang.RuntimeException: XXX");
    }

    @Test
    public void testSignalStartEventDataMapping() throws Exception {
        KieSession ksession = this.createKSession(SIGNAL_DATA_MAPPING);
        final ArrayList list = new ArrayList();
        final ArrayList variableList = new ArrayList();
        ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                list.add(event.getProcessInstance().getId());
                variableList.add((String)((WorkflowProcessInstance)event.getProcessInstance()).getVariable("x"));
            }
        });
        ksession.signalEvent("MyStartSignal", (Object)"NewValue");
        Assertions.assertThat(list).hasSize(1);
        Assertions.assertThat((String)((String)variableList.get(0))).isEqualTo("NewValue");
    }

    @Test
    public void testSignalOutputType() throws Exception {
        KieSession ksession = this.createKSession(SIGNAL_OUTPUT_TYPE);
        SignalObjectReport report = new SignalObjectReport("Type of signal object report");
        ksession.signalEvent("SignalObjectReport", (Object)report);
        List vars = this.getLogService().findVariableInstancesByName("report", false);
        VariableInstanceLog lastvar = (VariableInstanceLog)vars.get(vars.size() - 1);
        Assertions.assertThat((String)lastvar.getValue()).isEqualTo(report.toString());
    }
}

