/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.regression.event;

import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jbpm.test.JbpmTestCase;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;

public class SubProcessWithTimerStartEventTest
extends JbpmTestCase {
    public SubProcessWithTimerStartEventTest() {
        super(true, true);
    }

    @Test
    public void simpleSupportProcessTest() throws Exception {
        this.createRuntimeManager(new String[]{"org/jbpm/test/regression/event/SubProcessWithTimerStartEvent.bpmn2"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        final CountDownLatch end = new CountDownLatch(1);
        final AtomicBoolean reached = new AtomicBoolean(false);
        ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
                String name = event.getNodeInstance().getNode().getName();
                if ("ScriptTask".equals(name)) {
                    reached.set(true);
                    end.countDown();
                } else if ("end2".equals(name)) {
                    end.countDown();
                }
            }
        });
        HashMap params = new HashMap();
        ProcessInstance processInstance = ksession.startProcess("SubProcessWithTimerStartEvent", params);
        end.await();
        Assert.assertFalse((boolean)reached.get());
        Assert.assertNull((Object)ksession.getProcessInstance(processInstance.getId()));
    }
}

