/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.listener;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.kie.api.event.rule.DefaultRuleRuntimeEventListener;
import org.kie.api.event.rule.ObjectDeletedEvent;
import org.kie.api.event.rule.ObjectInsertedEvent;
import org.kie.api.event.rule.ObjectUpdatedEvent;

public class TrackingRuleRuntimeEventListener
extends DefaultRuleRuntimeEventListener {
    private List<Object> objects = new CopyOnWriteArrayList<Object>();
    private List<Object> inserted = new ArrayList<Object>();
    private List<Object> updated = new ArrayList<Object>();
    private List<Object> retracted = new ArrayList<Object>();

    public void objectInserted(ObjectInsertedEvent event) {
        this.objects.add(event.getObject());
        this.inserted.add(event.getObject());
    }

    public void objectDeleted(ObjectDeletedEvent event) {
        this.objects.remove(event.getOldObject());
        this.retracted.add(event.getOldObject());
    }

    public void objectUpdated(ObjectUpdatedEvent event) {
        this.objects.set(this.objects.indexOf(event.getOldObject()), event.getObject());
        this.updated.add(event.getOldObject());
    }

    public boolean containsObject(Object o) {
        return this.objects.contains(o);
    }

    public boolean hasObjects() {
        return this.objects.size() > 0;
    }

    public int objectCount() {
        return this.objects.size();
    }

    public void clear() {
        this.objects.clear();
        this.inserted.clear();
        this.updated.clear();
        this.retracted.clear();
    }

    public boolean wasInserted(Object o) {
        return this.inserted.contains(o);
    }

    public boolean wasUpdated(Object o) {
        return this.updated.contains(o);
    }

    public boolean wasRetracted(Object o) {
        return this.retracted.contains(o);
    }
}

