/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.gateway;

import java.util.HashMap;
import javax.persistence.EntityManagerFactory;
import org.jbpm.executor.ExecutorServiceFactory;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.wih.ListWorkItemHandler;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.executor.ExecutorService;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;

public class ParallelGatewayAsyncTest
extends JbpmTestCase {
    private static final String PARALLEL_GATEWAY_ASYNC = "org/jbpm/test/functional/gateway/ParallelGatewayAsync.bpmn";
    private static final String PARALLEL_GATEWAY_ASYNC_ID = "org.jbpm.test.functional.gateway.ParallelGatewayAsync";
    private ExecutorService executorService;
    private KieSession kieSession;
    private ListWorkItemHandler wih;

    public ParallelGatewayAsyncTest() {
        super(true, true);
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.executorService = ExecutorServiceFactory.newExecutorService((EntityManagerFactory)this.getEmf());
        this.executorService.setInterval(1);
        this.executorService.init();
        this.addEnvironmentEntry("AsyncMode", "true");
        this.addEnvironmentEntry("ExecutorService", this.executorService);
        this.wih = new ListWorkItemHandler();
        this.addWorkItemHandler("Human Task", (WorkItemHandler)this.wih);
        this.kieSession = this.createKSession(PARALLEL_GATEWAY_ASYNC);
    }

    @After
    public void tearDown() throws Exception {
        this.executorService.clearAllErrors();
        this.executorService.clearAllRequests();
        this.executorService.destroy();
        super.tearDown();
    }

    @Test(timeout=30000L)
    public void testParallelGatewayAsync() throws Exception {
        HashMap<String, Object> inputs = new HashMap<String, Object>();
        inputs.put("useHT", Boolean.TRUE);
        inputs.put("mode", "1");
        ProcessInstance pi = this.kieSession.startProcess(PARALLEL_GATEWAY_ASYNC_ID, inputs);
        Thread.sleep(3000L);
        this.wih.getWorkItems().forEach(e -> this.kieSession.getWorkItemManager().completeWorkItem(e.getId(), e.getParameters()));
        Thread.sleep(1000L);
        Assert.assertNull((Object)this.kieSession.getProcessInstance(pi.getId()));
    }
}

