/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.listener.IterableProcessEventListener;
import org.jbpm.test.tools.IterableListenerAssert;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.internal.command.CommandFactory;

public class RuleTaskTest
extends JbpmTestCase {
    private static final String RULE_TASK = "org/jbpm/test/functional/task/RuleTask.bpmn";
    private static final String RULE_TASK_ID = "org.jbpm.test.functional.task.RuleTask";
    private static final String RULE_TASK_DRL = "org/jbpm/test/functional/task/RuleTask.drl";
    private static final String RULE_TASK_2 = "org/jbpm/test/functional/task/RuleTask2.bpmn2";
    private static final String RULE_TASK_2_ID = "org.jbpm.test.functional.task.RuleTask2";
    private static final String RULE_TASK_2_DRL = "org/jbpm/test/functional/task/RuleTask2.drl";
    private static final String DMN_TASK = "org/jbpm/test/functional/task/DMNOutputExpressionProcess.bpmn";
    private static final String DMN_TASK_ID = "org.jbpm.test.functional.task.DMNOutputExpressionProcess";
    private static final String DMN_TASK_DRL = "org/jbpm/test/functional/task/DMNOutputExpression.dmn";

    public RuleTaskTest() {
        super(false);
    }

    @Test(timeout=30000L)
    public void testRuleTask() {
        String[] expected;
        HashMap<String, ResourceType> res = new HashMap<String, ResourceType>();
        res.put(RULE_TASK, ResourceType.BPMN2);
        res.put(RULE_TASK_DRL, ResourceType.DRL);
        KieSession kieSession = this.createKSession(res);
        ArrayList executedRules = new ArrayList();
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(CommandFactory.newSetGlobal((String)"executed", executedRules));
        commands.add(CommandFactory.newStartProcess((String)RULE_TASK_ID));
        commands.add(CommandFactory.newFireAllRules());
        IterableProcessEventListener listener = new IterableProcessEventListener();
        kieSession.addEventListener((ProcessEventListener)listener);
        kieSession.execute((Command)CommandFactory.newBatchExecution(commands));
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)listener, (String)RULE_TASK_ID);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)listener, (String)"start");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)listener, (String)"rules");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)listener, (String)"end");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)listener, (String)RULE_TASK_ID);
        Assert.assertEquals((long)3L, (long)executedRules.size());
        for (String expectedRuleName : expected = new String[]{"firstRule", "secondRule", "thirdRule"}) {
            Assert.assertTrue((boolean)executedRules.contains(expectedRuleName));
        }
    }

    @Test(timeout=30000L)
    public void testRuleTaskInsertFact() {
        String[] expected;
        HashMap<String, ResourceType> res = new HashMap<String, ResourceType>();
        res.put(RULE_TASK, ResourceType.BPMN2);
        res.put(RULE_TASK_DRL, ResourceType.DRL);
        KieSession kieSession = this.createKSession(res);
        ArrayList executedRules = new ArrayList();
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(CommandFactory.newSetGlobal((String)"executed", executedRules));
        commands.add(CommandFactory.newInsert((Object)6));
        commands.add(CommandFactory.newStartProcess((String)RULE_TASK_ID));
        commands.add(CommandFactory.newFireAllRules());
        IterableProcessEventListener listener = new IterableProcessEventListener();
        kieSession.addEventListener((ProcessEventListener)listener);
        kieSession.execute((Command)CommandFactory.newBatchExecution(commands));
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)listener, (String)RULE_TASK_ID);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)listener, (String)"start");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)listener, (String)"rules");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)listener, (String)"end");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)listener, (String)RULE_TASK_ID);
        Assert.assertEquals((long)4L, (long)executedRules.size());
        for (String expectedRuleName : expected = new String[]{"firstRule", "secondRule", "thirdRule", "fifthRule"}) {
            Assert.assertTrue((boolean)executedRules.contains(expectedRuleName));
        }
    }

    @Test(timeout=30000L)
    public void testRuleTask2() {
        HashMap<String, ResourceType> res = new HashMap<String, ResourceType>();
        res.put(RULE_TASK_2, ResourceType.BPMN2);
        res.put(RULE_TASK_2_DRL, ResourceType.DRL);
        KieSession ksession = this.createKSession(res);
        ksession.getEnvironment().set("org.jbpm.rule.task.waitstate", (Object)true);
        ProcessInstance pi = ksession.startProcess(RULE_TASK_2_ID);
        Assert.assertNotNull((Object)pi);
        Assert.assertEquals((long)1L, (long)pi.getState());
        ksession.fireAllRules();
        WorkflowProcessInstance wpi = (WorkflowProcessInstance)pi;
        List executeRuleList = (List)wpi.getVariable("results");
        Assert.assertNotNull((Object)executeRuleList);
        for (String s : executeRuleList) {
            System.out.println(s);
        }
        Assert.assertEquals((long)2L, (long)executeRuleList.size());
        pi = ksession.startProcess(RULE_TASK_2_ID);
        Assert.assertNotNull((Object)pi);
        Assert.assertEquals((long)1L, (long)pi.getState());
        ksession.fireAllRules();
        wpi = (WorkflowProcessInstance)pi;
        executeRuleList = (List)wpi.getVariable("results");
        Assert.assertNotNull((Object)executeRuleList);
        for (String s : executeRuleList) {
            System.out.println(s);
        }
        Assert.assertEquals((long)2L, (long)executeRuleList.size());
    }

    @Test(timeout=30000L)
    public void testRuleDMNOutputExpressionTask() {
        HashMap<String, ResourceType> res = new HashMap<String, ResourceType>();
        res.put(DMN_TASK, ResourceType.BPMN2);
        res.put(DMN_TASK_DRL, ResourceType.DMN);
        KieSession ksession = this.createKSession(res);
        ksession.getEnvironment().set("org.jbpm.rule.task.waitstate", (Object)true);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("output", "Generated Date");
        ProcessInstance pi = ksession.startProcess(DMN_TASK_ID, parameters);
        Assert.assertNotNull((Object)pi);
        Assert.assertEquals((long)2L, (long)pi.getState());
        WorkflowProcessInstance wpi = (WorkflowProcessInstance)pi;
        Assert.assertNotNull((Object)wpi.getVariable("date"));
    }

    @Override
    public KieSession createKSession(Map<String, ResourceType> res) {
        this.createRuntimeManager(res);
        return this.getRuntimeEngine().getKieSession();
    }
}

