/*
 * Copyright 2017 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jbpm.workbench.cm.client.resources.i18n;

import org.jboss.errai.ui.shared.api.annotations.TranslationKey;

public interface Constants {

    @TranslationKey(defaultValue = "")
    String CASE = "Case";

    @TranslationKey(defaultValue = "")
    String OWNER = "Owner";

    @TranslationKey(defaultValue = "")
    String CASES_LIST = "CasesList";

    @TranslationKey(defaultValue = "")
    String CASE_CREATED_WITH_ID = "CaseCreatedWithId";

    @TranslationKey(defaultValue = "")
    String INVALID_CASE_DEFINITION = "InvalidCaseDefinition";

    @TranslationKey(defaultValue = "")
    String PLEASE_SELECT_CASE_DEFINITION = "PleaseSelectCaseDefinition";

    @TranslationKey(defaultValue = "")
    String NO_CASE_DEFINITION = "NoCaseDefinition";

    @TranslationKey(defaultValue = "")
    String PLEASE_SELECT_ROLE = "PleaseSelectRole";

    @TranslationKey(defaultValue = "")
    String CASE_OVERVIEW = "CaseOverview";

    @TranslationKey(defaultValue = "")
    String CASE_DETAILS = "CaseDetails";

    @TranslationKey(defaultValue = "")
    String ROLES = "Roles";

    @TranslationKey(defaultValue = "")
    String REMOVE = "Remove";

    @TranslationKey(defaultValue = "")
    String PLEASE_INTRO_USER_OR_GROUP_TO_CREATE_ASSIGNMENT = "PleaseIntroUserOrGroupToCreateAssignment";

    @TranslationKey(defaultValue = "")
    String CASE_COMMENTS = "Comments";

    @TranslationKey(defaultValue = "")
    String CASE_COMMENT_CANT_BE_EMPTY = "CommentCannotBeEmpty";

    @TranslationKey(defaultValue = "")
    String DELETE = "Delete";

    @TranslationKey(defaultValue = "")
    String EDIT = "Edit";

    @TranslationKey(defaultValue = "")
    String UPDATE = "Update";

    @TranslationKey(defaultValue = "")
    String CANCEL = "Cancel";

    @TranslationKey(defaultValue = "")
    String MILESTONES = "Milestones";

    @TranslationKey(defaultValue = "")
    String MILESTONES_HAS_NOT_BEEN_COMPLETED = "MilestonHasNotBeenCompleted";

    @TranslationKey(defaultValue = "")
    String MILESTONES_HAS_BEEN_TERMINATED = "MilestonHasBeenTerminated";

    @TranslationKey(defaultValue = "")
    String MILESTONES_HAS_BEEN_COMPLETED = "MilestonHasBeenCompleted";

    @TranslationKey(defaultValue = "")
    String CASE_STAGES = "CaseStages";

    @TranslationKey(defaultValue = "")
    String CASE_ACTIONS = "CaseActions";

    @TranslationKey(defaultValue = "")
    String ACTION_START = "ActionStart";

    @TranslationKey(defaultValue = "")
    String NEW_USER_TASK = "NewUserTask";

    @TranslationKey(defaultValue = "")
    String NEW_PROCESS_TASK = "NewProcessTask";

    @TranslationKey(defaultValue = "")
    String PLEASE_INTRO_ACTION_NAME = "PleaseIntroActionName";

    @TranslationKey(defaultValue = "")
    String PLEASE_INTRO_USER_OR_GROUP_TO_ASSIGN_NEW_ACTION = "PleaseIntroUserOrGroupToAssignTheNewAction";

    @TranslationKey(defaultValue = "")
    String PLEASE_INTRO_SUBPROCESS_ID = "PleaseIntroSubprocessId";

    @TranslationKey(defaultValue = "")
    String PLEASE_PROVIDE_CASE_OWNER = "PleaseProvideCaseOwner";

    @TranslationKey(defaultValue = "")
    String AVAILABLE_IN = "AvailableIn";

    @TranslationKey(defaultValue = "")
    String DYMANIC = "Dynamic";

    @TranslationKey(defaultValue = "")
    String DELETE_COMMENT = "DeleteComment";

    @TranslationKey(defaultValue = "")
    String DELETE_THIS_COMMENT = "DeleteThisComment";

    @TranslationKey(defaultValue = "")
    String SORT_BY_DATE_ASC = "SortByDateAsc";

    @TranslationKey(defaultValue = "")
    String SORT_BY_DATE_DESC = "SortByDateDesc";

    @TranslationKey(defaultValue = "")
    String SORT_BY_NAME_ASC = "SortByNameAsc";

    @TranslationKey(defaultValue = "")
    String SORT_BY_NAME_DESC = "SortByNameDesc";
}