/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.roles;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Button;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Event;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.cm.client.pagination.PaginationViewImpl;
import org.jbpm.workbench.cm.client.roles.CaseRoleItemView;
import org.jbpm.workbench.cm.client.roles.CaseRolesPresenter;
import org.uberfire.mvp.Command;

@Dependent
@Templated
public class CaseRolesViewImpl
implements CaseRolesPresenter.CaseRolesView,
PaginationViewImpl.PageList {
    public static int PAGE_SIZE = 4;
    @Inject
    @DataField(value="roles")
    private Div rolesContainer;
    @Inject
    @DataField(value="roles-badge")
    Span rolesBadge;
    @Inject
    @DataField(value="role-list")
    private Div roles;
    @Inject
    @DataField(value="user-add")
    private Button userAddButton;
    @Inject
    @DataField(value="scrollbox")
    private Div scrollbox;
    @Inject
    @DataField(value="pagination")
    private PaginationViewImpl pagination;
    List allElementsList = new ArrayList();
    private Command userAddCommand;
    @Inject
    private ManagedInstance<CaseRoleItemView> provider;

    public void init(CaseRolesPresenter presenter) {
    }

    @Override
    public void removeAllRoles() {
        DOMUtil.removeAllChildren((Node)this.roles);
        this.allElementsList = new ArrayList();
    }

    @Override
    public void enableNewRoleAssignments() {
        DOMUtil.removeCSSClass((HTMLElement)this.userAddButton, (String)"hidden");
    }

    @Override
    public void disableNewRoleAssignments() {
        DOMUtil.addCSSClass((HTMLElement)this.userAddButton, (String)"hidden");
    }

    @Override
    public void setUserAddCommand(Command command) {
        this.userAddCommand = command;
    }

    @Override
    public void addUser(String userName, String roleName, CaseRolesPresenter.CaseRoleAction ... actions) {
        this.addRoleView(userName, roleName, "pficon-user", actions);
    }

    @Override
    public void addGroup(String groupName, String roleName, CaseRolesPresenter.CaseRoleAction ... actions) {
        this.addRoleView(groupName, roleName, "pficon-users", actions);
    }

    private void addRoleView(String name, String roleName, String iconType, CaseRolesPresenter.CaseRoleAction ... actions) {
        CaseRoleItemView roleItemView = (CaseRoleItemView)this.provider.get();
        roleItemView.setRoleName(roleName);
        roleItemView.setName(name);
        roleItemView.setIconType(iconType);
        for (CaseRolesPresenter.CaseRoleAction action : actions) {
            roleItemView.addAction(action);
        }
        this.allElementsList.add(roleItemView);
    }

    @Override
    public void setupPagination() {
        this.rolesBadge.setTextContent(String.valueOf(this.allElementsList.size()));
        this.pagination.init(this.allElementsList, this, PAGE_SIZE);
    }

    @Override
    public void setVisibleItems(List visibleItems) {
        DOMUtil.removeAllChildren((Node)this.roles);
        int visibleItemsSize = visibleItems.size();
        if (visibleItemsSize > 0) {
            visibleItems.stream().forEach(e -> ((CaseRoleItemView)e).setLastElementStyle(false));
            ((CaseRoleItemView)visibleItems.get(visibleItemsSize - 1)).setLastElementStyle(true);
        }
        visibleItems.stream().forEach(e -> this.roles.appendChild((Node)((CaseRoleItemView)e).getElement()));
    }

    @Override
    public Div getScrollBox() {
        return this.scrollbox;
    }

    @EventHandler(value={"user-add"})
    public void onUserAddClick(@ForEvent(value={"click"}) Event e) {
        if (this.userAddCommand != null) {
            this.userAddCommand.execute();
        }
    }

    public HTMLElement getElement() {
        return this.rolesContainer;
    }
}

