/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.list;

import java.util.Arrays;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Button;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Form;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.MouseEvent;
import org.jboss.errai.databinding.client.api.DataBinder;
import org.jboss.errai.databinding.client.api.StateSync;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.AutoBound;
import org.jboss.errai.ui.shared.api.annotations.Bound;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.jbpm.workbench.cm.client.list.CaseInstanceListPresenter;
import org.jbpm.workbench.cm.client.list.CaseInstanceSearchSortByConverter;
import org.jbpm.workbench.cm.client.util.AbstractView;
import org.jbpm.workbench.cm.client.util.CaseStatusConverter;
import org.jbpm.workbench.cm.client.util.Select;
import org.jbpm.workbench.cm.util.CaseInstanceSearchRequest;
import org.jbpm.workbench.cm.util.CaseInstanceSortBy;
import org.jbpm.workbench.cm.util.CaseStatus;

@Dependent
@Templated(value="CaseInstanceListViewImpl.html#search-actions")
public class CaseInstanceListSearchViewImpl
extends AbstractView<CaseInstanceListPresenter> {
    @Inject
    @DataField(value="search-actions")
    private Form actions;
    @Inject
    @Bound(converter=CaseInstanceSearchSortByConverter.class)
    @DataField(value="sort-select")
    private Select sortBy;
    @Inject
    @Bound(converter=CaseStatusConverter.class)
    @DataField(value="status-select")
    private Select status;
    @Inject
    @DataField(value="sort-case-id-asc")
    private Button sortCaseIdAsc;
    @Inject
    @DataField(value="sort-case-id-desc")
    private Button sortCaseIdDesc;
    @Inject
    @DataField(value="sort-started-asc")
    private Button sortStartedAsc;
    @Inject
    @DataField(value="sort-started-desc")
    private Button sortStartedDesc;
    @Inject
    @AutoBound
    private DataBinder<CaseInstanceSearchRequest> searchRequest;
    @Inject
    private TranslationService translationService;

    public HTMLElement getElement() {
        return this.actions;
    }

    @PostConstruct
    public void init() {
        Arrays.stream(CaseStatus.values()).forEach(s -> this.status.addOption(this.translationService.format(s.getLabel(), new Object[0]), s.getName()));
        this.status.refresh();
        Arrays.stream(CaseInstanceSortBy.values()).collect(Collectors.toMap(s -> s.name(), s -> this.translationService.format(s.name(), new Object[0]))).entrySet().stream().sorted((e1, e2) -> ((String)e1.getValue()).compareTo((String)e2.getValue())).forEach(s -> this.sortBy.addOption((String)s.getValue(), (String)s.getKey()));
        this.sortBy.refresh();
        this.searchRequest.addPropertyChangeHandler("sortBy", e -> {
            if (e.getNewValue() == CaseInstanceSortBy.CASE_ID) {
                DOMUtil.addCSSClass((HTMLElement)this.sortStartedAsc, (String)"hidden");
                DOMUtil.addCSSClass((HTMLElement)this.sortStartedDesc, (String)"hidden");
                this.onSortCaseIdDesc(null);
            } else {
                DOMUtil.addCSSClass((HTMLElement)this.sortCaseIdAsc, (String)"hidden");
                DOMUtil.addCSSClass((HTMLElement)this.sortCaseIdDesc, (String)"hidden");
                this.onSortStartedDesc(null);
            }
        });
        this.searchRequest.setModel((Object)new CaseInstanceSearchRequest(), StateSync.FROM_MODEL);
        this.searchRequest.addPropertyChangeHandler(e -> ((CaseInstanceListPresenter)this.presenter).searchCaseInstances());
    }

    public CaseInstanceSearchRequest getCaseInstanceSearchRequest() {
        return (CaseInstanceSearchRequest)this.searchRequest.getModel();
    }

    @EventHandler(value={"start-case"})
    public void onCreateCaseClick(@ForEvent(value={"click"}) MouseEvent event) {
        ((CaseInstanceListPresenter)this.presenter).createCaseInstance();
    }

    @EventHandler(value={"sort-case-id-asc"})
    public void onSortCaseIdAsc(@ForEvent(value={"click"}) MouseEvent event) {
        this.onSortChange((HTMLElement)this.sortCaseIdAsc, (HTMLElement)this.sortCaseIdDesc, false);
    }

    @EventHandler(value={"sort-case-id-desc"})
    public void onSortCaseIdDesc(@ForEvent(value={"click"}) MouseEvent event) {
        this.onSortChange((HTMLElement)this.sortCaseIdDesc, (HTMLElement)this.sortCaseIdAsc, true);
    }

    @EventHandler(value={"sort-started-asc"})
    public void onSortStartedAsc(@ForEvent(value={"click"}) MouseEvent event) {
        this.onSortChange((HTMLElement)this.sortStartedAsc, (HTMLElement)this.sortStartedDesc, false);
    }

    @EventHandler(value={"sort-started-desc"})
    public void onSortStartedDesc(@ForEvent(value={"click"}) MouseEvent event) {
        this.onSortChange((HTMLElement)this.sortStartedDesc, (HTMLElement)this.sortStartedAsc, true);
    }

    private void onSortChange(HTMLElement toHide, HTMLElement toShow, Boolean sortByAsc) {
        DOMUtil.addCSSClass((HTMLElement)toHide, (String)"hidden");
        DOMUtil.removeCSSClass((HTMLElement)toShow, (String)"hidden");
        CaseInstanceSearchRequest model = (CaseInstanceSearchRequest)this.searchRequest.getWorkingModel();
        model.setSortByAsc(sortByAsc);
    }
}

