/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.pagination;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Event;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.ForEvent;
import org.jboss.errai.ui.shared.api.annotations.Templated;

@Dependent
@Templated
public class PaginationViewImpl
implements IsElement {
    @Inject
    @DataField(value="pagination")
    private Div pagination;
    @Inject
    @DataField(value="nextPage")
    Anchor nextPage;
    @Inject
    @DataField(value="prevPage")
    Anchor prevPage;
    List allElementsList = new ArrayList();
    int currentPage = 0;
    int pageSize;
    PageList pageList;

    public void init(List allElementsList, PageList pageList, int pageSize) {
        this.allElementsList = allElementsList;
        this.pageList = pageList;
        this.pageSize = pageSize;
        this.setVisibleItemsList(this.currentPage);
    }

    protected void setVisibleItemsList(int currentPage) {
        List visibleItems;
        this.currentPage = currentPage;
        int allItemsSize = this.allElementsList.size();
        boolean hasPrevPage = false;
        boolean hasNextPage = false;
        if (currentPage != 0) {
            hasPrevPage = true;
        }
        if (this.pageSize * (currentPage + 1) < allItemsSize) {
            hasNextPage = true;
            visibleItems = this.allElementsList.subList(this.pageSize * currentPage, this.pageSize * (currentPage + 1));
        } else {
            visibleItems = this.allElementsList.subList(this.pageSize * currentPage, allItemsSize);
        }
        boolean showPagination = false;
        DOMUtil.removeCSSClass((HTMLElement)this.pageList.getScrollBox(), (String)"kie-end-scroll");
        DOMUtil.removeCSSClass((HTMLElement)this.pageList.getScrollBox(), (String)"kie-start-scroll");
        DOMUtil.removeCSSClass((HTMLElement)this.pageList.getScrollBox(), (String)"kie-both-scroll");
        if (hasNextPage) {
            showPagination = true;
            DOMUtil.removeCSSClass((HTMLElement)this.nextPage, (String)"disabled");
            if (hasPrevPage) {
                DOMUtil.addCSSClass((HTMLElement)this.pageList.getScrollBox(), (String)"kie-both-scroll");
            } else {
                DOMUtil.addCSSClass((HTMLElement)this.pageList.getScrollBox(), (String)"kie-end-scroll");
            }
        } else {
            DOMUtil.addCSSClass((HTMLElement)this.nextPage, (String)"disabled");
        }
        if (hasPrevPage) {
            showPagination = true;
            DOMUtil.removeCSSClass((HTMLElement)this.prevPage, (String)"disabled");
            DOMUtil.addCSSClass((HTMLElement)this.pageList.getScrollBox(), (String)"kie-start-scroll");
        } else {
            DOMUtil.addCSSClass((HTMLElement)this.prevPage, (String)"disabled");
        }
        this.pagination.setHidden(!showPagination);
        if (visibleItems.size() == 1) {
            DOMUtil.addCSSClass((HTMLElement)this.pageList.getScrollBox(), (String)"kie-scrollbox-show-overflow");
        } else {
            DOMUtil.removeCSSClass((HTMLElement)this.pageList.getScrollBox(), (String)"kie-scrollbox-show-overflow");
        }
        this.pageList.setVisibleItems(visibleItems);
    }

    @EventHandler(value={"nextPage"})
    public void onNextPageClick(@ForEvent(value={"click"}) Event event) {
        if (!DOMUtil.hasCSSClass((HTMLElement)this.nextPage, (String)"disabled")) {
            this.setVisibleItemsList(this.currentPage + 1);
        }
    }

    @EventHandler(value={"prevPage"})
    public void onPrevPageClick(@ForEvent(value={"click"}) Event event) {
        if (!DOMUtil.hasCSSClass((HTMLElement)this.prevPage, (String)"disabled")) {
            this.setVisibleItemsList(this.currentPage - 1);
        }
    }

    public HTMLElement getElement() {
        return this.pagination;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public static interface PageList<T> {
        public void setVisibleItems(List<T> var1);

        public Div getScrollBox();
    }
}

