/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.overview;

import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jbpm.workbench.cm.client.events.CaseCancelEvent;
import org.jbpm.workbench.cm.client.events.CaseDestroyEvent;
import org.jbpm.workbench.cm.client.events.CaseRefreshEvent;
import org.jbpm.workbench.cm.client.util.AbstractCaseInstancePresenter;
import org.jbpm.workbench.cm.model.CaseInstanceSummary;
import org.jbpm.workbench.cm.service.CaseManagementService;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.lifecycle.OnOpen;

@Dependent
@WorkbenchScreen(identifier="Case Overview")
public class CaseOverviewPresenter
extends AbstractCaseInstancePresenter<CaseOverviewView> {
    public static final String SCREEN_ID = "Case Overview";
    @Inject
    PlaceManager placeManager;
    private Event<CaseCancelEvent> caseCancelEvent;
    private Event<CaseDestroyEvent> caseDestroyEvent;
    private Event<CaseRefreshEvent> caseRefreshEvent;

    @WorkbenchPartTitle
    public String getTitle() {
        return this.translationService.format("CaseOverview", new Object[0]);
    }

    @OnOpen
    public void onOpen() {
        ((CaseOverviewView)this.view).addCaseDetails("Case Details Screen", this.place.getParameters());
        ((CaseOverviewView)this.view).addCaseRoles("Case Roles", this.place.getParameters());
        ((CaseOverviewView)this.view).addCaseComments("Case Comments", this.place.getParameters());
        ((CaseOverviewView)this.view).addCaseMilestones("Case Milestone List", this.place.getParameters());
        ((CaseOverviewView)this.view).addCaseStages("Case Stages Screen", this.place.getParameters());
        ((CaseOverviewView)this.view).addCaseActions("Case Actions", this.place.getParameters());
    }

    protected void refreshCase() {
        this.caseRefreshEvent.fire((Object)new CaseRefreshEvent(this.caseId));
    }

    @Override
    protected void clearCaseInstance() {
        ((CaseOverviewView)this.view).setCaseTitle("");
        ((CaseOverviewView)this.view).setCaseId("");
        ((CaseOverviewView)this.view).setCaseOwner("");
    }

    @Override
    protected void loadCaseInstance(CaseInstanceSummary cis) {
        ((CaseOverviewView)this.view).setCaseTitle(cis.getDescription());
        ((CaseOverviewView)this.view).setCaseId(cis.getCaseId());
        ((CaseOverviewView)this.view).setCaseOwner(cis.getOwner());
    }

    protected void cancelCaseInstance() {
        ((CaseManagementService)this.caseService.call(e -> {
            this.caseCancelEvent.fire((Object)new CaseCancelEvent(this.caseId));
            this.backToList();
        })).cancelCaseInstance(this.serverTemplateId, this.containerId, this.caseId);
    }

    protected void destroyCaseInstance() {
        ((CaseManagementService)this.caseService.call(e -> {
            this.caseDestroyEvent.fire((Object)new CaseDestroyEvent(this.caseId));
            this.backToList();
        })).destroyCaseInstance(this.serverTemplateId, this.containerId, this.caseId);
    }

    protected void backToList() {
        this.placeManager.goTo("CaseList");
    }

    @Inject
    public void setCaseCancelEvent(Event<CaseCancelEvent> caseCancelEvent) {
        this.caseCancelEvent = caseCancelEvent;
    }

    @Inject
    public void setCaseDestroyEvent(Event<CaseDestroyEvent> caseDestroyEvent) {
        this.caseDestroyEvent = caseDestroyEvent;
    }

    @Inject
    public void setCaseRefreshEvent(Event<CaseRefreshEvent> caseRefreshEvent) {
        this.caseRefreshEvent = caseRefreshEvent;
    }

    public static interface CaseOverviewView
    extends UberElement<CaseOverviewPresenter> {
        public void setCaseTitle(String var1);

        public void setCaseId(String var1);

        public void setCaseOwner(String var1);

        public void addCaseDetails(String var1, Map<String, String> var2);

        public void addCaseStages(String var1, Map<String, String> var2);

        public void addCaseActions(String var1, Map<String, String> var2);

        public void addCaseComments(String var1, Map<String, String> var2);

        public void addCaseFiles(String var1, Map<String, String> var2);

        public void addCaseRoles(String var1, Map<String, String> var2);

        public void addCaseMilestones(String var1, Map<String, String> var2);

        public void addCaseActivities(String var1, Map<String, String> var2);
    }
}

