/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.roles;

import com.google.gwt.user.client.TakesValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jbpm.workbench.cm.client.util.AbstractCaseInstancePresenter;
import org.jbpm.workbench.cm.client.util.CaseRolesAssignmentFilterBy;
import org.jbpm.workbench.cm.client.util.CaseRolesValidations;
import org.jbpm.workbench.cm.model.CaseDefinitionSummary;
import org.jbpm.workbench.cm.model.CaseInstanceSummary;
import org.jbpm.workbench.cm.model.CaseRoleAssignmentSummary;
import org.jbpm.workbench.cm.service.CaseManagementService;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.mvp.Command;

@Dependent
@WorkbenchScreen(identifier="Case Roles")
public class CaseRolesPresenter
extends AbstractCaseInstancePresenter<CaseRolesView> {
    public static final String SCREEN_ID = "Case Roles";
    public static final String CASE_OWNER_ROLE = "owner";
    @Inject
    private EditRoleAssignmentView editRoleAssignmentView;
    @Inject
    CaseRolesValidations caseRolesValidations;
    List<CaseRoleAssignmentSummary> allUnfilteredElements = new ArrayList<CaseRoleAssignmentSummary>();
    private CaseDefinitionSummary caseDefinition;

    @WorkbenchPartTitle
    public String getTittle() {
        return this.translationService.format("Roles", new Object[0]);
    }

    @Override
    protected void clearCaseInstance() {
        ((CaseRolesView)this.view).removeAllRoles();
        this.allUnfilteredElements = new ArrayList<CaseRoleAssignmentSummary>();
        ((CaseRolesView)this.view).setBadge("0");
    }

    @Override
    protected void loadCaseInstance(CaseInstanceSummary cis) {
        this.setupExistingAssignments(cis);
    }

    protected void setupExistingAssignments(CaseInstanceSummary cis) {
        ((CaseManagementService)this.caseService.call(cds -> {
            if (cds == null || cds.getRoles() == null || cds.getRoles().isEmpty()) {
                return;
            }
            this.caseDefinition = cds;
            this.allUnfilteredElements = cds.getRoles().keySet().stream().map(roleName -> this.getRoleAssignment(cis, (String)roleName)).collect(Collectors.toList());
            ((CaseRolesView)this.view).setBadge(String.valueOf(this.allUnfilteredElements.size()));
            this.filterElements();
        })).getCaseDefinition(this.serverTemplateId, this.containerId, cis.getCaseDefinitionId());
    }

    public void filterElements() {
        String filterBy = ((CaseRolesView)this.view).getFilterValue();
        if (filterBy.equals(CaseRolesAssignmentFilterBy.ASSIGNED.getLabel())) {
            ((CaseRolesView)this.view).setRolesAssignmentList(this.allUnfilteredElements.stream().filter(caseRoleAssignmentSummary -> caseRoleAssignmentSummary.hasAssignment()).collect(Collectors.toList()));
        } else if (filterBy.equals(CaseRolesAssignmentFilterBy.UNASSIGNED.getLabel())) {
            ((CaseRolesView)this.view).setRolesAssignmentList(this.allUnfilteredElements.stream().filter(caseRoleAssignmentSummary -> !caseRoleAssignmentSummary.hasAssignment()).collect(Collectors.toList()));
        } else {
            ((CaseRolesView)this.view).setRolesAssignmentList(this.allUnfilteredElements);
        }
    }

    public void editAction(CaseRoleAssignmentSummary caseRoleAssignmentSummary) {
        this.editRoleAssignmentView.setValue(CaseRoleAssignmentSummary.builder().name(caseRoleAssignmentSummary.getName()).users(caseRoleAssignmentSummary.getUsers()).groups(caseRoleAssignmentSummary.getGroups()).build());
        this.editRoleAssignmentView.show(() -> this.assignToRole(caseRoleAssignmentSummary));
    }

    protected CaseRoleAssignmentSummary getRoleAssignment(CaseInstanceSummary cis, String roleName) {
        if (CASE_OWNER_ROLE.equals(roleName)) {
            return CaseRoleAssignmentSummary.builder().name(roleName).users(Arrays.asList(cis.getOwner())).build();
        }
        return cis.getRoleAssignments().stream().filter(ra -> roleName.equals(ra.getName())).findFirst().orElse(CaseRoleAssignmentSummary.builder().name(roleName).build());
    }

    protected void assignToRole(CaseRoleAssignmentSummary previousAssignment) {
        List<String> assignmentErrors = this.caseRolesValidations.validateRolesAssignments(this.caseDefinition, Arrays.asList((CaseRoleAssignmentSummary)this.editRoleAssignmentView.getValue()));
        if (!assignmentErrors.isEmpty()) {
            this.editRoleAssignmentView.showValidationError(assignmentErrors);
            return;
        }
        this.editRoleAssignmentView.hide();
        this.storeRoleAssignments(previousAssignment, ((CaseRoleAssignmentSummary)this.editRoleAssignmentView.getValue()).getUsers(), ((CaseRoleAssignmentSummary)this.editRoleAssignmentView.getValue()).getGroups());
    }

    protected void storeRoleAssignments(CaseRoleAssignmentSummary prevCaseRoleAssignmentSummary, List<String> users, List<String> groups) {
        List prevUserAssignments = prevCaseRoleAssignmentSummary.getUsers();
        List prevGroupsAssignments = prevCaseRoleAssignmentSummary.getGroups();
        List newUserAssignments = users.stream().distinct().collect(Collectors.toList());
        List newGroupsAssignments = groups.stream().distinct().collect(Collectors.toList());
        prevCaseRoleAssignmentSummary.setUsers(new ArrayList(newUserAssignments));
        prevCaseRoleAssignmentSummary.setGroups(new ArrayList(newGroupsAssignments));
        this.filterElements();
        ArrayList usersToRemove = new ArrayList(prevUserAssignments);
        usersToRemove.removeAll(newUserAssignments);
        usersToRemove.forEach(user -> ((CaseManagementService)this.caseService.call()).removeUserFromRole(this.serverTemplateId, this.containerId, this.caseId, prevCaseRoleAssignmentSummary.getName(), user));
        newUserAssignments.removeAll(prevUserAssignments);
        newUserAssignments.stream().forEach(user -> ((CaseManagementService)this.caseService.call()).assignUserToRole(this.serverTemplateId, this.containerId, this.caseId, prevCaseRoleAssignmentSummary.getName(), user));
        ArrayList groupsToRemove = new ArrayList(prevGroupsAssignments);
        groupsToRemove.removeAll(newGroupsAssignments);
        groupsToRemove.forEach(group -> ((CaseManagementService)this.caseService.call()).removeGroupFromRole(this.serverTemplateId, this.containerId, this.caseId, prevCaseRoleAssignmentSummary.getName(), group));
        newGroupsAssignments.removeAll(prevGroupsAssignments);
        newGroupsAssignments.stream().forEach(group -> ((CaseManagementService)this.caseService.call()).assignGroupToRole(this.serverTemplateId, this.containerId, this.caseId, prevCaseRoleAssignmentSummary.getName(), group));
    }

    protected void removeUserFromRole(String userName, CaseRoleAssignmentSummary caseRoleAssignmentSummary) {
        ((CaseManagementService)this.caseService.call(Void2 -> {
            List users = caseRoleAssignmentSummary.getUsers();
            users.remove(userName);
            caseRoleAssignmentSummary.setUsers(users);
            this.filterElements();
        })).removeUserFromRole(this.serverTemplateId, this.containerId, this.caseId, caseRoleAssignmentSummary.getName(), userName);
    }

    protected void removeGroupFromRole(String groupName, CaseRoleAssignmentSummary caseRoleAssignmentSummary) {
        ((CaseManagementService)this.caseService.call(Void2 -> {
            List groups = caseRoleAssignmentSummary.getGroups();
            groups.remove(groupName);
            caseRoleAssignmentSummary.setGroups(groups);
            this.filterElements();
        })).removeGroupFromRole(this.serverTemplateId, this.containerId, this.caseId, caseRoleAssignmentSummary.getName(), groupName);
    }

    public static interface CaseAssignmentItem
    extends Command {
        public String label();
    }

    public static interface CaseRoleAction
    extends Command {
        public String label();

        public boolean isEnabled();
    }

    public static interface EditRoleAssignmentView
    extends UberElement<CaseRolesPresenter>,
    TakesValue<CaseRoleAssignmentSummary> {
        public void show(Command var1);

        public void showValidationError(List<String> var1);

        public void hide();
    }

    public static interface CaseRolesView
    extends UberElement<CaseRolesPresenter> {
        public void removeAllRoles();

        public void setRolesAssignmentList(List<CaseRoleAssignmentSummary> var1);

        public void resetPagination();

        public String getFilterValue();

        public void setBadge(String var1);
    }
}

