/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.cm.client.util;

import com.google.common.base.Strings;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jbpm.workbench.cm.client.events.CaseRefreshEvent;
import org.jbpm.workbench.cm.client.util.AbstractPresenter;
import org.jbpm.workbench.cm.model.CaseInstanceSummary;
import org.jbpm.workbench.cm.service.CaseManagementService;
import org.uberfire.client.mvp.UberElement;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;

public abstract class AbstractCaseInstancePresenter<V extends UberElement>
extends AbstractPresenter<V> {
    public static final String PARAMETER_CASE_ID = "caseId";
    public static final String PARAMETER_SERVER_TEMPLATE_ID = "serverTemplateId";
    public static final String PARAMETER_CONTAINER_ID = "containerId";
    protected PlaceRequest place;
    protected String caseId;
    protected String serverTemplateId;
    protected String containerId;
    @Inject
    protected TranslationService translationService;
    protected Caller<CaseManagementService> caseService;

    @OnStartup
    public void onStartup(PlaceRequest place) {
        this.place = place;
        this.caseId = place.getParameter(PARAMETER_CASE_ID, null);
        this.serverTemplateId = place.getParameter(PARAMETER_SERVER_TEMPLATE_ID, null);
        this.containerId = place.getParameter(PARAMETER_CONTAINER_ID, null);
        this.findCaseInstance();
    }

    protected abstract void loadCaseInstance(CaseInstanceSummary var1);

    protected abstract void clearCaseInstance();

    public void findCaseInstance() {
        this.clearCaseInstance();
        if (this.isCaseInstanceValid()) {
            ((CaseManagementService)this.caseService.call(cis -> this.loadCaseInstance((CaseInstanceSummary)cis))).getCaseInstance(this.serverTemplateId, this.containerId, this.caseId);
        }
    }

    protected boolean isCaseInstanceValid() {
        return !Strings.isNullOrEmpty((String)this.containerId) && !Strings.isNullOrEmpty((String)this.caseId);
    }

    public void onCaseRefreshEvent(@Observes CaseRefreshEvent caseRefreshEvent) {
        this.findCaseInstance();
    }

    @Inject
    public void setCaseService(Caller<CaseManagementService> caseService) {
        this.caseService = caseService;
    }
}

